/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api;

import java.util.Arrays;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.wiki.jpa.BaseTest;
import org.exoplatform.wiki.model.Attachment;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.WikiService;

public class TestPageAttachment
extends BaseTest {
    private WikiService wikiService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.wikiService = (WikiService)this.getContainer().getComponentInstanceOfType(WikiService.class);
    }

    public void testAddPageAttachment() throws Exception {
        Wiki wiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, "wikiAttachement1");
        Page wikiHome = wiki.getWikiHome();
        Attachment attachment = new Attachment();
        attachment.setName("attachment1.png");
        attachment.setContent("logo".getBytes());
        attachment.setMimeType("image/png");
        attachment.setCreator("root");
        this.wikiService.addAttachmentToPage(attachment, wikiHome);
        Attachment storedAttachment = this.wikiService.getAttachmentOfPageByName("attachment1.png", wikiHome, true);
        TestPageAttachment.assertNotNull((Object)storedAttachment);
        TestPageAttachment.assertNotNull((Object)storedAttachment.getName());
        TestPageAttachment.assertEquals((String)attachment.getName(), (String)storedAttachment.getName());
        TestPageAttachment.assertNotNull((Object)storedAttachment.getContent());
        TestPageAttachment.assertTrue((boolean)Arrays.equals(attachment.getContent(), storedAttachment.getContent()));
    }
}

