/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.handler;

import io.meeds.notes.handler.TermsAndConditionsHandler;
import io.meeds.notes.service.TermsAndConditionsService;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={TermsAndConditionsHandler.class})
class TermsAndConditionsHandlerTest {
    @Mock
    private WebAppController webAppController;
    @Mock
    private ServletConfig servletConfig;
    @MockBean
    ControllerContext controllerContext;
    @MockBean
    private HttpServletRequest httpRequest;
    @MockBean
    private HttpServletResponse httpResponse;
    @MockBean
    private TermsAndConditionsService termsService;
    @MockBean
    private UserPortalConfigService portalConfigService;
    @MockBean
    private PortalContainer container;
    @Autowired
    private TermsAndConditionsHandler handler;

    TermsAndConditionsHandlerTest() {
    }

    @Test
    void testUserHasAcceptedTermsAndRequestIsForTermsPage() throws Exception {
        Mockito.when((Object)((TermsAndConditionsService)this.container.getComponentInstanceOfType(TermsAndConditionsService.class))).thenReturn((Object)this.termsService);
        Mockito.when((Object)((UserPortalConfigService)this.container.getComponentInstanceOfType(UserPortalConfigService.class))).thenReturn((Object)this.portalConfigService);
        Mockito.when((Object)this.controllerContext.getRequest()).thenReturn((Object)this.httpRequest);
        Mockito.when((Object)this.controllerContext.getResponse()).thenReturn((Object)this.httpResponse);
        Mockito.when((Object)this.httpRequest.getContextPath()).thenReturn((Object)"/portal");
        Mockito.when((Object)this.httpRequest.getRemoteUser()).thenReturn((Object)"testUser");
        Mockito.when((Object)this.httpRequest.getRequestURI()).thenReturn((Object)"/portal/terms-and-conditions");
        Mockito.when((Object)this.httpRequest.getQueryString()).thenReturn(null);
        Mockito.when((Object)this.httpRequest.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.termsService.isTermsAcceptedForUser("testUser", "en")).thenReturn((Object)true);
        Mockito.when((Object)this.portalConfigService.getMetaPortal()).thenReturn((Object)"classic");
        try (MockedStatic mockedStatic = Mockito.mockStatic(PortalContainer.class);){
            mockedStatic.when(PortalContainer::getInstance).thenReturn((Object)this.container);
            this.handler.onInit(this.webAppController, this.servletConfig);
            boolean executed = this.handler.execute(this.controllerContext);
            ((HttpServletResponse)Mockito.verify((Object)this.httpResponse)).sendRedirect("/portal/classic/settings#terms-and-conditions");
            Assertions.assertTrue((boolean)executed);
        }
    }

    @Test
    void testUserHasNotAcceptedTerms() throws Exception {
        Mockito.when((Object)((TermsAndConditionsService)this.container.getComponentInstanceOfType(TermsAndConditionsService.class))).thenReturn((Object)this.termsService);
        Mockito.when((Object)((UserPortalConfigService)this.container.getComponentInstanceOfType(UserPortalConfigService.class))).thenReturn((Object)this.portalConfigService);
        Mockito.when((Object)this.controllerContext.getRequest()).thenReturn((Object)this.httpRequest);
        Mockito.when((Object)this.controllerContext.getResponse()).thenReturn((Object)this.httpResponse);
        Mockito.when((Object)this.httpRequest.getContextPath()).thenReturn((Object)"/portal");
        Mockito.when((Object)this.httpRequest.getRemoteUser()).thenReturn((Object)"testUser");
        Mockito.when((Object)this.httpRequest.getRequestURI()).thenReturn((Object)"/portal/home");
        Mockito.when((Object)this.httpRequest.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.termsService.isTermsAcceptedForUser("testUser", null)).thenReturn((Object)false);
        Mockito.when((Object)this.portalConfigService.getMetaPortal()).thenReturn((Object)"classic");
        try (MockedStatic mockedStatic = Mockito.mockStatic(PortalContainer.class);){
            mockedStatic.when(PortalContainer::getInstance).thenReturn((Object)this.container);
            this.handler.onInit(this.webAppController, this.servletConfig);
            boolean executed = this.handler.execute(this.controllerContext);
            String encodedPreviousPage = URLEncoder.encode("/portal/home", StandardCharsets.UTF_8);
            ((HttpServletResponse)Mockito.verify((Object)this.httpResponse)).sendRedirect("/portal/classic/terms-and-conditions?redirect=" + encodedPreviousPage);
            Assertions.assertTrue((boolean)executed);
        }
    }

    @Test
    void testAnonymousUser() throws Exception {
        Mockito.when((Object)this.controllerContext.getRequest()).thenReturn((Object)this.httpRequest);
        Mockito.when((Object)this.controllerContext.getResponse()).thenReturn((Object)this.httpResponse);
        Mockito.when((Object)this.httpRequest.getRemoteUser()).thenReturn(null);
        this.handler.onInit(this.webAppController, this.servletConfig);
        boolean executed = this.handler.execute(this.controllerContext);
        ((HttpServletResponse)Mockito.verify((Object)this.httpResponse, (VerificationMode)Mockito.never())).sendRedirect(Mockito.anyString());
        Assertions.assertFalse((boolean)executed);
    }
}

