/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.tag.model.TagName;
import org.exoplatform.social.metadata.tag.model.TagObject;

public class AnalyticsAddTagListener
extends Listener<TagObject, Set<TagName>> {
    private final IdentityManager identityManager;
    private static final String NOTES_METADATA_OBJECT_TYPE = "notes";

    public AnalyticsAddTagListener(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    public void onEvent(Event<TagObject, Set<TagName>> event) {
        if (ConversationState.getCurrent() == null) {
            return;
        }
        TagObject tagObject = (TagObject)event.getSource();
        Set tagNames = (Set)event.getData();
        if (tagObject.getType().equals(NOTES_METADATA_OBJECT_TYPE)) {
            int numberOfTags = tagNames.size();
            String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
            long userId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(currentUser).getId());
            StatisticData statisticData = new StatisticData();
            statisticData.setModule("portal");
            statisticData.setSubModule("ui");
            statisticData.setOperation("Add tag");
            statisticData.setTimestamp(new Date().getTime());
            statisticData.setUserId(userId);
            statisticData.addParameter("username", (Object)currentUser);
            statisticData.addParameter("dataType", (Object)StringUtils.lowerCase((String)tagObject.getType()));
            statisticData.addParameter("spaceId", (Object)tagObject.getSpaceId());
            for (int i = 0; i < numberOfTags; ++i) {
                AnalyticsUtils.addStatisticData((StatisticData)statisticData);
            }
        }
    }
}

