/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.plugin;

import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.service.NoteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NoteAclPlugin
implements AclPlugin {
    public static final String OBJECT_TYPE = "notes";
    @Autowired
    private PortalContainer container;
    @Autowired
    private NoteService noteService;

    @PostConstruct
    public void init() {
        ((UserACL)this.container.getComponentInstanceOfType(UserACL.class)).addAclPlugin((AclPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasPermission(String objectId, String permissionType, Identity identity) {
        Page note = this.noteService.getNoteById(objectId);
        PermissionType permType = switch (permissionType) {
            case "VIEW" -> PermissionType.VIEWPAGE;
            case "EDIT" -> PermissionType.EDITPAGE;
            default -> null;
        };
        return note != null && permType != null && this.noteService.hasPermissionOnPage(note, permType, identity);
    }
}

