/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.notes.listener.TermsAndConditionsAnalyticsListener;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest(classes={TermsAndConditionsAnalyticsListener.class})
@TestPropertySource(properties={"spring.profiles.active=analytics"})
class TermsAndConditionsAnalyticsListenerTest {
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private Event<String, Object> event;
    @Autowired
    private TermsAndConditionsAnalyticsListener listener;

    TermsAndConditionsAnalyticsListenerTest() {
    }

    @Test
    void onEvent() {
        try (MockedStatic mockedStatic = Mockito.mockStatic(AnalyticsUtils.class);){
            String username = "testUser";
            long userId = 123L;
            mockedStatic.when(() -> AnalyticsUtils.getUserIdentityId((String)username)).thenReturn((Object)userId);
            Mockito.when((Object)((String)this.event.getSource())).thenReturn((Object)username);
            this.listener.onEvent(this.event);
            ArgumentCaptor captor = ArgumentCaptor.forClass(StatisticData.class);
            mockedStatic.verify(() -> AnalyticsUtils.addStatisticData((StatisticData)((StatisticData)Mockito.argThat(statisticData -> {
                Assertions.assertEquals((Object)"social", (Object)statisticData.getModule());
                Assertions.assertEquals((Object)"terms", (Object)statisticData.getSubModule());
                Assertions.assertEquals((Object)"acceptTermsAndConditions", (Object)statisticData.getOperation());
                Assertions.assertEquals((long)userId, (long)statisticData.getUserId());
                return true;
            }))), Mockito.times((int)1));
            AnalyticsUtils.addStatisticData((StatisticData)((StatisticData)captor.capture()));
        }
    }
}

