/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.exoplatform.wiki.jpa.BaseWikiJPAIntegrationTest;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.junit.Test;

public class PageDAOTest
extends BaseWikiJPAIntegrationTest {
    @Test
    public void testGetPageOfWikiByName() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity parentPage = new PageEntity();
        parentPage.setWiki(wiki);
        parentPage.setName("parentPage1");
        parentPage.setCreatedDate(new Date());
        parentPage.setUpdatedDate(new Date());
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setParentPage(parentPage);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        this.pageDAO.create((Object)parentPage);
        this.pageDAO.create((Object)page);
        PageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        PageEntity pageOfWikiByName = this.pageDAO.getPageOfWikiByName("portal", "wiki1", "page1");
        PageDAOTest.assertNotNull((Object)pageOfWikiByName);
        PageDAOTest.assertEquals((String)"portal", (String)pageOfWikiByName.getWiki().getType());
        PageDAOTest.assertEquals((String)"wiki1", (String)pageOfWikiByName.getWiki().getOwner());
        PageDAOTest.assertEquals((String)"page1", (String)pageOfWikiByName.getName());
        PageDAOTest.assertEquals((String)"Page 1", (String)pageOfWikiByName.getTitle());
    }

    @Test
    public void testInsert() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setAuthor("author");
        page.setContent("content");
        page.setComment("comment");
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("name");
        page.setMinorEdit(true);
        page.setOwner("owner");
        page.setSyntax("syntax");
        page.setTitle("title");
        page.setUrl("url");
        this.pageDAO.create((Object)page);
        PageEntity got = (PageEntity)this.pageDAO.find((Serializable)Long.valueOf(page.getId()));
        PageDAOTest.assertNotNull((Object)got);
        PageDAOTest.assertEquals((String)"name", (String)got.getName());
    }

    @Test
    public void testDuplicatedWikiOwnerTypeInsert() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        try {
            WikiEntity wiki1 = new WikiEntity();
            wiki1.setType("portal");
            wiki1.setOwner("wiki1");
            wiki1 = (WikiEntity)this.wikiDAO.create((Object)wiki1);
            PageDAOTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCountAllIds() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity parentPage = new PageEntity();
        parentPage.setWiki(wiki);
        parentPage.setName("parentPage1");
        parentPage.setCreatedDate(new Date());
        parentPage.setUpdatedDate(new Date());
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setParentPage(parentPage);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        this.pageDAO.create((Object)parentPage);
        this.pageDAO.create((Object)page);
        PageDAOTest.assertEquals((int)2, (int)this.pageDAO.countAllIds().intValue());
    }

    @Test
    public void testFindAllBySyntax() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity parentPage = new PageEntity();
        parentPage.setWiki(wiki);
        parentPage.setName("parentPage1");
        parentPage.setCreatedDate(new Date());
        parentPage.setUpdatedDate(new Date());
        parentPage.setSyntax("syntax1");
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setParentPage(parentPage);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setSyntax("syntax2");
        this.pageDAO.create((Object)parentPage);
        this.pageDAO.create((Object)page);
        List fetchedPages = this.pageDAO.findAllBySyntax("syntax2", 0, 10);
        PageDAOTest.assertEquals((int)1, (int)fetchedPages.size());
        PageDAOTest.assertEquals((String)"page1", (String)((PageEntity)fetchedPages.get(0)).getName());
    }
}

