/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.storage;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.dao.DraftPageDAO;
import org.exoplatform.wiki.jpa.dao.PageDAO;
import org.exoplatform.wiki.jpa.dao.PageMoveDAO;
import org.exoplatform.wiki.jpa.dao.PageVersionDAO;
import org.exoplatform.wiki.jpa.dao.TemplateDAO;
import org.exoplatform.wiki.jpa.dao.WikiDAO;
import org.exoplatform.wiki.jpa.entity.BasePageEntity;
import org.exoplatform.wiki.jpa.entity.DraftPageEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.PageMoveEntity;
import org.exoplatform.wiki.jpa.entity.PageVersionEntity;
import org.exoplatform.wiki.jpa.entity.TemplateEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.exoplatform.wiki.jpa.search.WikiElasticSearchServiceConnector;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.SearchResultType;
import org.exoplatform.wiki.service.search.TemplateSearchData;
import org.exoplatform.wiki.service.search.TemplateSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.storage.EntityConverter;
import org.exoplatform.wiki.storage.NoteDataStorage$AjcClosure1;
import org.exoplatform.wiki.storage.NoteDataStorage$AjcClosure11;
import org.exoplatform.wiki.storage.NoteDataStorage$AjcClosure13;
import org.exoplatform.wiki.storage.NoteDataStorage$AjcClosure15;
import org.exoplatform.wiki.storage.NoteDataStorage$AjcClosure17;
import org.exoplatform.wiki.storage.NoteDataStorage$AjcClosure3;
import org.exoplatform.wiki.storage.NoteDataStorage$AjcClosure5;
import org.exoplatform.wiki.storage.NoteDataStorage$AjcClosure7;
import org.exoplatform.wiki.storage.NoteDataStorage$AjcClosure9;
import org.exoplatform.wiki.utils.VersionNameComparatorDesc;

public class NoteDataStorage {
    public static final String WIKI_TYPE_DRAFT = "draft";
    public static final String WIKI_FILES_NAMESPACE_NAME = "wiki";
    private WikiDAO wikiDAO;
    private PageDAO pageDAO;
    private DraftPageDAO draftPageDAO;
    private PageVersionDAO pageVersionDAO;
    private PageMoveDAO pageMoveDAO;
    private TemplateDAO templateDAO;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    public NoteDataStorage(WikiDAO wikiDAO, PageDAO pageDAO, DraftPageDAO draftPageDAO, PageVersionDAO pageVersionDAO, PageMoveDAO pageMoveDAO, TemplateDAO templateDAO) {
        this.wikiDAO = wikiDAO;
        this.pageDAO = pageDAO;
        this.draftPageDAO = draftPageDAO;
        this.pageVersionDAO = pageVersionDAO;
        this.pageMoveDAO = pageMoveDAO;
        this.templateDAO = templateDAO;
    }

    public PageList<SearchResult> search(WikiSearchData wikiSearchData) {
        if (wikiSearchData == null) {
            return new ObjectPageList(Collections.emptyList(), 0);
        }
        WikiElasticSearchServiceConnector searchService = (WikiElasticSearchServiceConnector)((Object)PortalContainer.getInstance().getComponentInstanceOfType(WikiElasticSearchServiceConnector.class));
        List<SearchResult> searchResults = searchService.searchWiki(this.getSearchedText(wikiSearchData), wikiSearchData);
        return new ObjectPageList(searchResults, searchResults.size());
    }

    private String getSearchedText(WikiSearchData wikiSearchData) {
        String searchText = "";
        if (StringUtils.isNotBlank((CharSequence)wikiSearchData.getTitle())) {
            searchText = wikiSearchData.getTitle();
        } else if (StringUtils.isNotBlank((CharSequence)wikiSearchData.getContent())) {
            searchText = wikiSearchData.getContent();
        }
        return searchText;
    }

    public Wiki getWikiByTypeAndOwner(String wikiType, String wikiOwner) throws WikiException {
        return EntityConverter.convertWikiEntityToWiki(this.wikiDAO.getWikiByTypeAndOwner(wikiType, wikiOwner));
    }

    public List<Wiki> getWikisByType(String wikiType) throws WikiException {
        return this.wikiDAO.getWikisByType(wikiType).stream().map(EntityConverter::convertWikiEntityToWiki).toList();
    }

    @ExoTransactional
    public Wiki createWiki(Wiki wiki) throws WikiException {
        Wiki wiki2 = wiki;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)wiki2);
        Object[] objectArray = new Object[]{this, wiki2, joinPoint};
        NoteDataStorage$AjcClosure1 noteDataStorage$AjcClosure1 = new NoteDataStorage$AjcClosure1(objectArray);
        return (Wiki)ExoTransactionalAspect.aspectOf().around(noteDataStorage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public Page createPage(Wiki wiki, Page parentPage, Page page) throws WikiException {
        Wiki wiki2 = wiki;
        Page page2 = parentPage;
        Page page3 = page;
        Object[] objectArray = new Object[]{wiki2, page2, page3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, wiki2, page2, page3, joinPoint};
        NoteDataStorage$AjcClosure3 noteDataStorage$AjcClosure3 = new NoteDataStorage$AjcClosure3(objectArray2);
        return (Page)ExoTransactionalAspect.aspectOf().around(noteDataStorage$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public Page getPageOfWikiByName(String wikiType, String wikiOwner, String pageName) throws WikiException {
        if (wikiType == null || wikiOwner == null) {
            return null;
        }
        if (WIKI_TYPE_DRAFT.equals(wikiType)) {
            return EntityConverter.convertDraftPageEntityToDraftPage(this.draftPageDAO.findDraftPageByName(pageName));
        }
        return EntityConverter.convertPageEntityToPage(this.pageDAO.getPageOfWikiByName(wikiType, wikiOwner, pageName));
    }

    public Page getPageById(String id) {
        return EntityConverter.convertPageEntityToPage((PageEntity)this.pageDAO.find(Long.valueOf(Long.parseLong(id))));
    }

    public DraftPage getDraftPageById(String id) {
        return EntityConverter.convertDraftPageEntityToDraftPage((DraftPageEntity)this.draftPageDAO.find(Long.valueOf(Long.parseLong(id))));
    }

    public Page getParentPageOf(Page page) throws WikiException {
        Page parentPage = null;
        PageEntity childPageEntity = null;
        childPageEntity = page.getId() != null && !page.getId().isEmpty() ? (PageEntity)this.pageDAO.find(Long.valueOf(Long.parseLong(page.getId()))) : this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (childPageEntity != null) {
            parentPage = EntityConverter.convertPageEntityToPage(childPageEntity.getParentPage());
        }
        return parentPage;
    }

    public List<Page> getChildrenPageOf(Page page, boolean withDrafts, boolean withChild) {
        List<DraftPageEntity> draftPageEntities;
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot get children of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<Page> childrenPages = new ArrayList<Page>();
        List<PageEntity> childrenPagesEntities = this.pageDAO.getChildrenPages(pageEntity);
        if (childrenPagesEntities != null) {
            for (PageEntity childPageEntity : childrenPagesEntities) {
                Page childPage = EntityConverter.convertPageEntityToPage(childPageEntity);
                if (withChild) {
                    childPage.setHasChild(this.hasChildren(Long.parseLong(childPage.getId())));
                }
                childrenPages.add(childPage);
            }
        }
        if (withDrafts && !(draftPageEntities = this.draftPageDAO.findDraftPagesByParentPage(pageEntity.getId())).isEmpty()) {
            for (DraftPageEntity draftPageEntity : draftPageEntities) {
                childrenPages.add(EntityConverter.convertDraftPageEntityToDraftPage(draftPageEntity));
            }
        }
        return childrenPages;
    }

    public boolean hasChildren(long noteId) {
        return this.pageDAO.countPageChildrenById(noteId) > 0L;
    }

    public boolean hasDrafts(long noteId) {
        return this.draftPageDAO.countDraftPagesByParentPage(noteId) > 0L;
    }

    @ExoTransactional
    public void deletePage(String pageId) throws WikiException {
        String string = pageId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        NoteDataStorage$AjcClosure5 noteDataStorage$AjcClosure5 = new NoteDataStorage$AjcClosure5(objectArray);
        ExoTransactionalAspect.aspectOf().around(noteDataStorage$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void deletePage(String wikiType, String wikiOwner, String pageName) throws WikiException {
        String string = wikiType;
        String string2 = wikiOwner;
        String string3 = pageName;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        NoteDataStorage$AjcClosure7 noteDataStorage$AjcClosure7 = new NoteDataStorage$AjcClosure7(objectArray2);
        ExoTransactionalAspect.aspectOf().around(noteDataStorage$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    private void deletePageEntity(PageEntity pageEntity) {
        List<PageEntity> childrenPages = this.pageDAO.getChildrenPages(pageEntity);
        if (childrenPages != null) {
            for (PageEntity childPage : childrenPages) {
                this.deletePageEntity(childPage);
            }
        }
        pageEntity.setDeleted(true);
        this.pageDAO.update(pageEntity);
    }

    public void deleteDraftOfPage(Page page) throws WikiException {
        this.draftPageDAO.deleteDraftPagesByTargetPage(Long.parseLong(page.getId()));
    }

    public void deleteDraftOfPage(Page page, String lang) throws WikiException {
        List<DraftPageEntity> draftPages = this.draftPageDAO.findDraftPagesByTargetPage(Long.parseLong(page.getId()));
        for (DraftPageEntity draftPage : draftPages) {
            if (draftPage == null || !StringUtils.equals((CharSequence)draftPage.getLang(), (CharSequence)lang)) continue;
            this.draftPageDAO.delete(draftPage);
        }
    }

    public void deleteDraftByName(String draftPageName) throws WikiException {
        this.draftPageDAO.deleteDraftPagesByName(draftPageName);
    }

    public void deleteDraftById(String id) throws WikiException {
        DraftPageEntity draftPageEntity = (DraftPageEntity)this.draftPageDAO.find(Long.valueOf(Long.parseLong(id)));
        this.draftPageDAO.delete(draftPageEntity);
    }

    @ExoTransactional
    public void renamePage(String wikiType, String wikiOwner, String pageName, String newName, String newTitle) throws WikiException {
        String string = wikiType;
        String string2 = wikiOwner;
        String string3 = pageName;
        String string4 = newName;
        String string5 = newTitle;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, string5, joinPoint};
        NoteDataStorage$AjcClosure9 noteDataStorage$AjcClosure9 = new NoteDataStorage$AjcClosure9(objectArray2);
        ExoTransactionalAspect.aspectOf().around(noteDataStorage$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void movePage(WikiPageParams currentLocationParams, WikiPageParams newLocationParams) throws WikiException {
        WikiPageParams wikiPageParams = currentLocationParams;
        WikiPageParams wikiPageParams2 = newLocationParams;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)wikiPageParams, (Object)wikiPageParams2);
        Object[] objectArray = new Object[]{this, wikiPageParams, wikiPageParams2, joinPoint};
        NoteDataStorage$AjcClosure11 noteDataStorage$AjcClosure11 = new NoteDataStorage$AjcClosure11(objectArray);
        ExoTransactionalAspect.aspectOf().around(noteDataStorage$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    private void updateWikiOfPageTree(WikiEntity wikiEntity, PageEntity pageEntity) {
        pageEntity.setWiki(wikiEntity);
        List<PageEntity> childrenPages = this.pageDAO.getChildrenPages(pageEntity);
        if (childrenPages != null) {
            for (PageEntity childrenPageEntity : childrenPages) {
                this.updateWikiOfPageTree(wikiEntity, childrenPageEntity);
            }
        }
    }

    public List<Page> getRelatedPagesOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot get related pages of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<Page> relatedPages = new ArrayList<Page>();
        List<PageEntity> relatedPagesEntities = pageEntity.getRelatedPages();
        if (relatedPagesEntities != null) {
            for (PageEntity relatedPageEntity : relatedPagesEntities) {
                relatedPages.add(EntityConverter.convertPageEntityToPage(relatedPageEntity));
            }
        }
        return relatedPages;
    }

    public Page getRelatedPage(String wikiType, String wikiOwner, String pageName) throws WikiException {
        Page relatedPage = null;
        List<PageMoveEntity> pageMoveEntities = this.pageMoveDAO.findInPageMoves(wikiType, wikiOwner, pageName);
        if (pageMoveEntities != null && !pageMoveEntities.isEmpty()) {
            relatedPage = EntityConverter.convertPageEntityToPage(pageMoveEntities.get(0).getPage());
        }
        return relatedPage;
    }

    public void addRelatedPage(Page page, Page relatedPage) throws WikiException {
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot add related page to page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        PageEntity relatedPageEntity = this.pageDAO.getPageOfWikiByName(relatedPage.getWikiType(), relatedPage.getWikiOwner(), relatedPage.getName());
        if (relatedPageEntity == null) {
            throw new WikiException("Cannot add related page " + relatedPage.getWikiType() + ":" + relatedPage.getWikiOwner() + ":" + relatedPage.getName() + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because related page does not exist.");
        }
        List<PageEntity> relatedPages = pageEntity.getRelatedPages();
        if (relatedPages == null) {
            relatedPages = new ArrayList<PageEntity>();
        }
        relatedPages.add(relatedPageEntity);
        pageEntity.setRelatedPages(relatedPages);
        this.pageDAO.update(pageEntity);
    }

    public List<Page> getPagesOfWiki(String wikiType, String wikiOwner) {
        if (StringUtils.isBlank((CharSequence)wikiOwner)) {
            throw new IllegalArgumentException("wikiOwner is mandatory argument");
        }
        if (StringUtils.isBlank((CharSequence)wikiType)) {
            throw new IllegalArgumentException("wikiType is mandatory argument");
        }
        List<PageEntity> pagesOfWiki = this.pageDAO.getPagesOfWiki(wikiType, wikiOwner, false);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (PageEntity pageEntity : pagesOfWiki) {
            pages.add(EntityConverter.convertPageEntityToPage(pageEntity));
        }
        return pages;
    }

    public void removeRelatedPage(Page page, Page relatedPage) throws WikiException {
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot remove related page to page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        PageEntity relatedPageEntity = this.pageDAO.getPageOfWikiByName(relatedPage.getWikiType(), relatedPage.getWikiOwner(), relatedPage.getName());
        if (relatedPageEntity == null) {
            throw new WikiException("Cannot remove related page " + relatedPage.getWikiType() + ":" + relatedPage.getWikiOwner() + ":" + relatedPage.getName() + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because related page does not exist.");
        }
        List<PageEntity> relatedPages = pageEntity.getRelatedPages();
        if (relatedPages != null) {
            for (int i = 0; i < relatedPages.size(); ++i) {
                if (relatedPages.get(i).getId() != relatedPageEntity.getId()) continue;
                relatedPages.remove(i);
                break;
            }
            pageEntity.setRelatedPages(relatedPages);
            this.pageDAO.update(pageEntity);
        }
    }

    public Page getExsitedOrNewDraftPageById(String wikiType, String wikiOwner, String pageName, String username) throws WikiException {
        DraftPageEntity draftPageEntity;
        DraftPage draftPage;
        if (pageName.contains("_A_A_")) {
            String[] pageNameParts = pageName.split("_A_A_");
            username = pageNameParts[0];
        }
        if ((draftPage = EntityConverter.convertDraftPageEntityToDraftPage(draftPageEntity = this.draftPageDAO.findDraftPageByName(pageName))) == null) {
            Page targetPage;
            Date now = Calendar.getInstance().getTime();
            draftPage = new DraftPage();
            draftPage.setWikiType(PortalConfig.USER_TYPE);
            draftPage.setWikiOwner(username);
            draftPage.setName(pageName);
            draftPage.setAuthor(username);
            draftPage.setNewPage(true);
            draftPage.setCreatedDate(now);
            draftPage.setUpdatedDate(now);
            if (wikiType != null && wikiOwner != null && (targetPage = this.getPageOfWikiByName(wikiType, wikiOwner, pageName)) != null) {
                draftPage.setTargetPageId(targetPage.getId());
                draftPage.setTargetPageRevision("1");
            }
            this.createDraftPageForUser(draftPage, username);
        }
        return draftPage;
    }

    public DraftPage getDraftOfPageByLang(Page page, String lang) throws WikiException {
        List<DraftPageEntity> draftPages = this.draftPageDAO.findDraftPagesByTargetPage(Long.parseLong(page.getId()));
        for (DraftPageEntity draftPage : draftPages) {
            if (draftPage == null || !StringUtils.equals((CharSequence)draftPage.getLang(), (CharSequence)lang)) continue;
            return EntityConverter.convertDraftPageEntityToDraftPage(draftPage);
        }
        return null;
    }

    public List<DraftPage> getDraftsOfPage(Long pageId) {
        return EntityConverter.convertDraftPageEntitiesToDraftPages(this.draftPageDAO.findDraftPagesByTargetPage(pageId));
    }

    public DraftPage getDraft(WikiPageParams wikiPageParams) throws WikiException {
        BasePageEntity latestDraftEntity;
        DraftPage latestDraft = null;
        Page page = this.getPageOfWikiByName(wikiPageParams.getType(), wikiPageParams.getOwner(), wikiPageParams.getPageName());
        if (page != null) {
            List<DraftPageEntity> draftPages = this.draftPageDAO.findDraftPagesByTargetPage(Long.valueOf(page.getId()));
            latestDraftEntity = null;
            for (DraftPageEntity draft : draftPages) {
                if (latestDraftEntity != null && latestDraftEntity.getUpdatedDate().getTime() >= draft.getUpdatedDate().getTime()) continue;
                latestDraftEntity = draft;
            }
        } else {
            throw new WikiException("Cannot get draft of page " + wikiPageParams.getType() + ":" + wikiPageParams.getOwner() + ":" + wikiPageParams.getPageName() + " because page does not exist.");
        }
        latestDraft = EntityConverter.convertDraftPageEntityToDraftPage(latestDraftEntity);
        return latestDraft;
    }

    public DraftPage getLatestDraftOfPage(Page targetPage) {
        DraftPageEntity draftPagEntity = this.draftPageDAO.findLatestDraftPageByTargetPage(Long.parseLong(targetPage.getId()));
        return EntityConverter.convertDraftPageEntityToDraftPage(draftPagEntity);
    }

    public DraftPage createDraftPageForUser(DraftPage draftPage, String username) throws WikiException {
        DraftPageEntity draftPageEntity = EntityConverter.convertDraftPageToDraftPageEntity(draftPage, this.pageDAO);
        if (username != null) {
            draftPageEntity.setAuthor(username);
        }
        draftPage = EntityConverter.convertDraftPageEntityToDraftPage((DraftPageEntity)this.draftPageDAO.create(draftPageEntity));
        return draftPage;
    }

    public DraftPage updateDraftPageForUser(DraftPage draftPage, String username) throws WikiException {
        DraftPageEntity draftPageEntity = EntityConverter.convertDraftPageToDraftPageEntity(draftPage, this.pageDAO);
        draftPageEntity.setAuthor(username);
        draftPage = EntityConverter.convertDraftPageEntityToDraftPage((DraftPageEntity)this.draftPageDAO.update(draftPageEntity));
        return draftPage;
    }

    public List<TemplateSearchResult> searchTemplate(TemplateSearchData templateSearchData) throws WikiException {
        String wikiOwner = templateSearchData.getWikiOwner();
        if (templateSearchData.getWikiType().toUpperCase().equals(WikiType.GROUP.toString())) {
            wikiOwner = this.templateDAO.validateGroupWikiOwner(wikiOwner);
        }
        List<TemplateEntity> templates = this.templateDAO.searchTemplatesByTitle(templateSearchData.getWikiType(), wikiOwner, templateSearchData.getTitle());
        ArrayList<TemplateSearchResult> searchResults = new ArrayList<TemplateSearchResult>();
        if (templates != null) {
            for (TemplateEntity templateEntity : templates) {
                Calendar createdDateCalendar = null;
                Date createdDate = templateEntity.getCreatedDate();
                if (createdDate != null) {
                    createdDateCalendar = Calendar.getInstance();
                    createdDateCalendar.setTime(createdDate);
                }
                Calendar updatedDateCalendar = null;
                Date updatedDate = templateEntity.getUpdatedDate();
                if (updatedDate != null) {
                    updatedDateCalendar = Calendar.getInstance();
                    updatedDateCalendar.setTime(updatedDate);
                }
                TemplateSearchResult templateSearchResult = new TemplateSearchResult(templateEntity.getWiki().getType(), templateEntity.getWiki().getOwner(), templateEntity.getName(), templateEntity.getTitle(), SearchResultType.TEMPLATE, updatedDateCalendar, createdDateCalendar, null);
                searchResults.add(templateSearchResult);
            }
        }
        return searchResults;
    }

    public List<PageVersion> getVersionsOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot get versions of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        List<PageVersionEntity> pageVersionEntities = pageEntity.getVersions();
        if (pageVersionEntities != null) {
            return pageVersionEntities.stream().map(EntityConverter::convertPageVersionEntityToPageVersion).sorted(new VersionNameComparatorDesc()).toList();
        }
        return Collections.emptyList();
    }

    public List<PageHistory> getHistoryOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot get versions of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        List<PageVersionEntity> pageVersionEntities = pageEntity.getVersions();
        if (pageVersionEntities != null) {
            return pageVersionEntities.stream().map(EntityConverter::convertPageVersionEntityToPageHistory).toList();
        }
        return Collections.emptyList();
    }

    @ExoTransactional
    public PageVersion addPageVersion(Page page, String userName) throws WikiException {
        Page page2 = page;
        String string = userName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)page2, (Object)string);
        Object[] objectArray = new Object[]{this, page2, string, joinPoint};
        NoteDataStorage$AjcClosure13 noteDataStorage$AjcClosure13 = new NoteDataStorage$AjcClosure13(objectArray);
        return (PageVersion)ExoTransactionalAspect.aspectOf().around(noteDataStorage$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    public PageVersion restoreVersionOfPage(String versionName, Page page) throws WikiException {
        if (page != null) {
            PageEntity pageEntity = this.fetchPageEntity(page);
            if (pageEntity == null) {
                throw new WikiException("Cannot restore version of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
            }
            PageVersionEntity versionToRestore = this.pageVersionDAO.getPageversionByPageIdAndVersion(Long.parseLong(page.getId()), Long.parseLong(versionName));
            if (versionToRestore != null) {
                pageEntity.setContent(versionToRestore.getContent());
                pageEntity.setUpdatedDate(Calendar.getInstance().getTime());
                this.pageDAO.update(pageEntity);
                return EntityConverter.convertPageVersionEntityToPageVersion(versionToRestore);
            }
            throw new WikiException("Cannot restore version " + versionName + " of a page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because version does not exist.");
        }
        throw new WikiException("Cannot restore version of a page null");
    }

    @ExoTransactional
    public Page updatePage(Page page) throws WikiException {
        Page page2 = page;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)page2);
        Object[] objectArray = new Object[]{this, page2, joinPoint};
        NoteDataStorage$AjcClosure15 noteDataStorage$AjcClosure15 = new NoteDataStorage$AjcClosure15(objectArray);
        return (Page)ExoTransactionalAspect.aspectOf().around(noteDataStorage$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    public List<String> getPreviousNamesOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot get previous names of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<String> previousPageName = new ArrayList<String>();
        List<PageMoveEntity> moves = pageEntity.getMoves();
        if (moves != null) {
            for (PageMoveEntity pageMoveEntity : moves) {
                previousPageName.add(pageMoveEntity.getPageName());
            }
        }
        return previousPageName;
    }

    public List<String> getWatchersOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot get watchers of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        return pageEntity.getWatchers() == null ? null : new ArrayList<String>(pageEntity.getWatchers());
    }

    public void addWatcherToPage(String username, Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot add a watcher on page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        if (pageEntity.getWatchers() == null) {
            throw new WikiException("Cannot add a watcher on page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because list of watchers is null.");
        }
        pageEntity.getWatchers().add(username);
        this.pageDAO.update(pageEntity);
    }

    public void deleteWatcherOfPage(String username, Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot delete a watcher of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        Set<String> watchers = pageEntity.getWatchers();
        if (watchers == null || !watchers.contains(username)) {
            throw new WikiException("Cannot remove watcher " + username + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because watcher does not exist.");
        }
        watchers.remove(username);
        pageEntity.setWatchers(watchers);
        this.pageDAO.update(pageEntity);
    }

    public PageEntity fetchPageEntity(Page page) {
        Long pageId = null;
        if (page.getId() != null && !page.getId().isEmpty()) {
            try {
                pageId = Long.parseLong(page.getId());
            }
            catch (NumberFormatException e) {
                pageId = null;
            }
        }
        PageEntity pageEntity = pageId != null ? (PageEntity)this.pageDAO.find(Long.valueOf(Long.parseLong(page.getId()))) : this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        return pageEntity;
    }

    public List<PageHistory> getPageHistoryVersionsByPageIdAndLang(Long pageId, String lang) {
        if (pageId == null) {
            throw new IllegalArgumentException("pageId argument is null");
        }
        return EntityConverter.toPageHistoryVersions(this.pageVersionDAO.findPageVersionsByPageIdAndLang(pageId, lang));
    }

    public DraftPage getLatestDraftPageByTargetPageAndLang(Long targetPageId, String lang) {
        if (targetPageId == null) {
            throw new IllegalArgumentException("targetPageId argument is null");
        }
        return EntityConverter.convertDraftPageEntityToDraftPage(this.draftPageDAO.findLatestDraftPageByTargetPageAndLang(targetPageId, lang));
    }

    public PageVersion getPublishedVersionByPageIdAndLang(Long pageId, String lang) {
        if (pageId == null) {
            throw new IllegalArgumentException("targetPageId argument is null");
        }
        PageVersion pageVersion = EntityConverter.convertPageVersionEntityToPageVersion(this.pageVersionDAO.findLatestVersionByPageIdAndLang(pageId, lang));
        if (pageVersion != null) {
            Page page = pageVersion.getParent();
            page.setLang(lang);
            EntityConverter.buildNotePageMetadata(page, false);
            pageVersion.setProperties(page.getProperties());
            return pageVersion;
        }
        return null;
    }

    public List<String> getPageAvailableTranslationLanguages(Long pageId) {
        if (pageId == null) {
            throw new IllegalArgumentException("pageId argument is null");
        }
        return this.pageVersionDAO.findPageAvailableTranslationLanguages(pageId);
    }

    @ExoTransactional
    public void deleteVersionsByNoteIdAndLang(Long noteId, String lang) throws WikiException {
        Long l = noteId;
        String string = lang;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)l, (Object)string);
        Object[] objectArray = new Object[]{this, l, string, joinPoint};
        NoteDataStorage$AjcClosure17 noteDataStorage$AjcClosure17 = new NoteDataStorage$AjcClosure17(objectArray);
        ExoTransactionalAspect.aspectOf().around(noteDataStorage$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    public void deleteOrphanDraftPagesByParentPage(long parentPageId) {
        this.draftPageDAO.deleteOrphanDraftPagesByParentPage(parentPageId);
    }

    public PageVersion getPageVersionById(long versionId) {
        return EntityConverter.convertPageVersionEntityToPageVersion((PageVersionEntity)this.pageVersionDAO.find(Long.valueOf(versionId)));
    }

    public Page updatePageContent(Page page, String content) {
        PageEntity pageTobeUpdated = this.fetchPageEntity(page);
        pageTobeUpdated.setContent(content);
        pageTobeUpdated.setUpdatedDate(new Date(System.currentTimeMillis()));
        return EntityConverter.convertPageEntityToPage((PageEntity)this.pageDAO.update(pageTobeUpdated));
    }

    public DraftPage updateDraftContent(long draftId, String content) {
        DraftPageEntity draftPageEntity = (DraftPageEntity)this.draftPageDAO.find(Long.valueOf(draftId));
        draftPageEntity.setContent(content);
        draftPageEntity.setUpdatedDate(new Date(System.currentTimeMillis()));
        return EntityConverter.convertDraftPageEntityToDraftPage((DraftPageEntity)this.draftPageDAO.update(draftPageEntity));
    }

    public List<DraftPage> getDraftsOfWiki(String wikiOwner, String wikiType, String wikiHome) {
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(wikiType, wikiOwner, wikiHome);
        ArrayList<DraftPageEntity> draftPageEntities = new ArrayList<DraftPageEntity>();
        this.getDraftsOfPage(pageEntity, draftPageEntities);
        return EntityConverter.convertDraftPageEntitiesToDraftPages(draftPageEntities);
    }

    private void getDraftsOfPage(PageEntity pageEntity, List<DraftPageEntity> drafts) {
        drafts.addAll(this.draftPageDAO.findDraftPagesByParentPage(pageEntity.getId()));
        List<PageEntity> childrenPages = this.pageDAO.getChildrenPages(pageEntity);
        for (PageEntity child : childrenPages) {
            this.getDraftsOfPage(child, drafts);
        }
    }

    static {
        NoteDataStorage.ajc$preClinit();
    }

    static final /* synthetic */ Wiki createWiki_aroundBody0(NoteDataStorage ajc$this, Wiki wiki, JoinPoint joinPoint) {
        WikiEntity createdWikiEntity = (WikiEntity)ajc$this.wikiDAO.create(EntityConverter.convertWikiToWikiEntity(wiki, ajc$this.wikiDAO));
        Wiki createdWiki = EntityConverter.convertWikiEntityToWiki(createdWikiEntity);
        Page wikiHomePage = new Page();
        wikiHomePage.setWikiType(wiki.getType());
        wikiHomePage.setWikiOwner(wiki.getOwner());
        wikiHomePage.setName("Home");
        wikiHomePage.setTitle("Home");
        Date now = Calendar.getInstance().getTime();
        wikiHomePage.setCreatedDate(now);
        wikiHomePage.setUpdatedDate(now);
        wikiHomePage.setContent("");
        wikiHomePage.setSyntax(createdWiki.getPreferences().getWikiPreferencesSyntax().getDefaultSyntax());
        Page createdWikiHomePage = ajc$this.createPage(createdWiki, null, wikiHomePage);
        createdWiki.setWikiHome(createdWikiHomePage);
        return createdWiki;
    }

    static final /* synthetic */ Page createPage_aroundBody2(NoteDataStorage ajc$this, Wiki wiki, Page parentPage, Page page, JoinPoint joinPoint) {
        WikiEntity wikiEntity = ajc$this.wikiDAO.getWikiByTypeAndOwner(wiki.getType(), wiki.getOwner());
        if (wikiEntity == null) {
            throw new WikiException("Cannot create page " + wiki.getType() + ":" + wiki.getOwner() + ":" + page.getName() + " because wiki does not exist.");
        }
        PageEntity parentPageEntity = null;
        if (parentPage != null && (parentPageEntity = ajc$this.pageDAO.getPageOfWikiByName(wiki.getType(), wiki.getOwner(), parentPage.getName())) == null) {
            throw new WikiException("Cannot create page " + wiki.getType() + ":" + wiki.getOwner() + ":" + page.getName() + " because parent page " + parentPage.getName() + " does not exist.");
        }
        PageEntity pageEntity = EntityConverter.convertPageToPageEntity(page, ajc$this.wikiDAO);
        pageEntity.setWiki(wikiEntity);
        pageEntity.setParentPage(parentPageEntity);
        Date now = Calendar.getInstance().getTime();
        if (pageEntity.getCreatedDate() == null) {
            pageEntity.setCreatedDate(now);
        }
        if (pageEntity.getUpdatedDate() == null) {
            pageEntity.setUpdatedDate(now);
        }
        pageEntity.setDeleted(false);
        PageEntity createdPageEntity = (PageEntity)ajc$this.pageDAO.create(pageEntity);
        if (parentPage == null && "Home".equals(createdPageEntity.getName())) {
            wikiEntity.setWikiHome(createdPageEntity);
            ajc$this.wikiDAO.update(wikiEntity);
        }
        return EntityConverter.convertPageEntityToPage(createdPageEntity);
    }

    static final /* synthetic */ void deletePage_aroundBody4(NoteDataStorage ajc$this, String pageId, JoinPoint joinPoint) {
        PageEntity pageEntity = (PageEntity)ajc$this.pageDAO.find(Long.valueOf(Long.parseLong(pageId)));
        ajc$this.deletePageEntity(pageEntity);
    }

    static final /* synthetic */ void deletePage_aroundBody6(NoteDataStorage ajc$this, String wikiType, String wikiOwner, String pageName, JoinPoint joinPoint) {
        PageEntity pageEntity = ajc$this.pageDAO.getPageOfWikiByName(wikiType, wikiOwner, pageName);
        if (pageEntity == null) {
            throw new WikiException("Cannot delete page " + wikiType + ":" + wikiOwner + ":" + pageName + " because page does not exist.");
        }
        ajc$this.deletePageEntity(pageEntity);
    }

    static final /* synthetic */ void renamePage_aroundBody8(NoteDataStorage ajc$this, String wikiType, String wikiOwner, String pageName, String newName, String newTitle, JoinPoint joinPoint) {
        PageEntity pageEntity = ajc$this.pageDAO.getPageOfWikiByName(wikiType, wikiOwner, pageName);
        if (pageEntity == null) {
            throw new WikiException("Cannot rename page " + wikiType + ":" + wikiOwner + ":" + pageName + " because page does not exist.");
        }
        List<PageMoveEntity> pageMoves = pageEntity.getMoves();
        if (pageMoves == null) {
            pageMoves = new ArrayList<PageMoveEntity>();
        }
        PageMoveEntity move = new PageMoveEntity(wikiType, wikiOwner, pageName, Calendar.getInstance().getTime());
        move.setPage(pageEntity);
        pageMoves.add(move);
        ajc$this.pageMoveDAO.create(move);
        pageEntity.setName(newName);
        pageEntity.setTitle(newTitle);
        pageEntity.setMoves(pageMoves);
        ajc$this.pageDAO.update(pageEntity);
    }

    static final /* synthetic */ void movePage_aroundBody10(NoteDataStorage ajc$this, WikiPageParams currentLocationParams, WikiPageParams newLocationParams, JoinPoint joinPoint) {
        PageEntity pageEntity = ajc$this.pageDAO.getPageOfWikiByName(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName());
        if (pageEntity == null) {
            throw new WikiException("Cannot move page " + currentLocationParams.getType() + ":" + currentLocationParams.getOwner() + ":" + currentLocationParams.getPageName() + " because page does not exist.");
        }
        PageEntity destinationPageEntity = ajc$this.pageDAO.getPageOfWikiByName(newLocationParams.getType(), newLocationParams.getOwner(), newLocationParams.getPageName());
        if (destinationPageEntity == null) {
            throw new WikiException("Cannot move page " + currentLocationParams.getType() + ":" + currentLocationParams.getOwner() + ":" + currentLocationParams.getPageName() + " to page " + newLocationParams.getType() + ":" + newLocationParams.getOwner() + ":" + newLocationParams.getPageName() + " because destination page does not exist.");
        }
        List<PageMoveEntity> pageMoves = pageEntity.getMoves();
        if (pageMoves == null) {
            pageMoves = new ArrayList<PageMoveEntity>();
        }
        PageMoveEntity move = new PageMoveEntity(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName(), Calendar.getInstance().getTime());
        move.setPage(pageEntity);
        ajc$this.pageMoveDAO.create(move);
        pageEntity.setParentPage(destinationPageEntity);
        ajc$this.updateWikiOfPageTree(destinationPageEntity.getWiki(), pageEntity);
        pageMoves.add(move);
        pageEntity.setMoves(pageMoves);
        ajc$this.pageDAO.update(pageEntity);
    }

    static final /* synthetic */ PageVersion addPageVersion_aroundBody12(NoteDataStorage ajc$this, Page page, String userName, JoinPoint joinPoint) {
        if (page != null) {
            PageEntity pageEntity = ajc$this.fetchPageEntity(page);
            if (pageEntity == null) {
                throw new WikiException("Cannot add version of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
            }
            PageVersionEntity pageVersionEntity = new PageVersionEntity();
            Long versionNumber = ajc$this.pageVersionDAO.getLastversionNumberOfPage(pageEntity.getId());
            versionNumber = versionNumber == null ? Long.valueOf(1L) : Long.valueOf(versionNumber + 1L);
            pageVersionEntity.setPage(pageEntity);
            pageVersionEntity.setVersionNumber(versionNumber);
            pageVersionEntity.setName(page.getName());
            pageVersionEntity.setTitle(page.getTitle());
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                pageVersionEntity.setAuthor(userName);
            } else {
                pageVersionEntity.setAuthor(pageEntity.getAuthor());
            }
            pageVersionEntity.setContent(page.getContent());
            pageVersionEntity.setSyntax(pageEntity.getSyntax());
            pageVersionEntity.setMinorEdit(pageEntity.isMinorEdit());
            pageVersionEntity.setComment(pageEntity.getComment());
            Date now = Calendar.getInstance().getTime();
            pageVersionEntity.setCreatedDate(now);
            pageVersionEntity.setUpdatedDate(now);
            pageVersionEntity.setLang(page.getLang());
            ajc$this.pageVersionDAO.create(pageVersionEntity);
            List<PageVersionEntity> pageVersionEntities = pageEntity.getVersions();
            if (pageVersionEntities == null) {
                pageVersionEntities = new ArrayList<PageVersionEntity>();
            }
            pageVersionEntities.add(pageVersionEntity);
            pageEntity.setVersions(pageVersionEntities);
            ajc$this.pageDAO.update(pageEntity);
            return EntityConverter.convertPageVersionEntityToPageVersion(pageVersionEntity);
        }
        throw new WikiException("Cannot create version of a page null");
    }

    static final /* synthetic */ Page updatePage_aroundBody14(NoteDataStorage ajc$this, Page page, JoinPoint joinPoint) {
        if (page.isDraftPage()) {
            DraftPageEntity draftPageEntity = ajc$this.draftPageDAO.findDraftPageByName(page.getName());
            if (draftPageEntity == null) {
                throw new WikiException("Cannot add an attachment to draft page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because draft page does not exist.");
            }
            draftPageEntity.setTitle(page.getTitle());
            draftPageEntity.setContent(page.getContent());
            draftPageEntity.setUpdatedDate(page.getUpdatedDate());
            return EntityConverter.convertDraftPageEntityToDraftPage((DraftPageEntity)ajc$this.draftPageDAO.update(draftPageEntity));
        }
        PageEntity pageEntity = ajc$this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot update page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        pageEntity.setName(page.getName());
        pageEntity.setTitle(page.getTitle());
        pageEntity.setAuthor(page.getAuthor());
        pageEntity.setContent(page.getContent());
        pageEntity.setSyntax(page.getSyntax());
        pageEntity.setCreatedDate(page.getCreatedDate());
        pageEntity.setUpdatedDate(page.getUpdatedDate());
        pageEntity.setMinorEdit(page.isMinorEdit());
        pageEntity.setComment(page.getComment());
        pageEntity.setUrl(page.getUrl());
        pageEntity.setActivityId(page.getActivityId());
        return EntityConverter.convertPageEntityToPage((PageEntity)ajc$this.pageDAO.update(pageEntity));
    }

    static final /* synthetic */ void deleteVersionsByNoteIdAndLang_aroundBody16(NoteDataStorage ajc$this, Long noteId, String lang, JoinPoint joinPoint) {
        if (noteId == null) {
            throw new IllegalArgumentException("noteId argument is null");
        }
        PageEntity pageEntity = (PageEntity)ajc$this.pageDAO.find(noteId);
        if (pageEntity == null) {
            throw new WikiException("Cannot delete versions of page with: " + noteId + "for language:" + lang + " because page does not exist.");
        }
        List<PageVersionEntity> history = ajc$this.pageVersionDAO.findPageVersionsByPageIdAndLang(noteId, lang);
        ajc$this.pageVersionDAO.deleteAll(history);
        history = pageEntity.getVersions();
        history.removeIf(version -> StringUtils.isNotEmpty((CharSequence)version.getLang()) && version.getLang().equals(lang));
        pageEntity.setVersions(history);
        ajc$this.pageDAO.update(pageEntity);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NoteDataStorage.java", NoteDataStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createWiki", "org.exoplatform.wiki.storage.NoteDataStorage", "org.exoplatform.wiki.model.Wiki", WIKI_FILES_NAMESPACE_NAME, "org.exoplatform.wiki.WikiException", "org.exoplatform.wiki.model.Wiki"), 143);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createPage", "org.exoplatform.wiki.storage.NoteDataStorage", "org.exoplatform.wiki.model.Wiki:org.exoplatform.wiki.model.Page:org.exoplatform.wiki.model.Page", "wiki:parentPage:page", "org.exoplatform.wiki.WikiException", "org.exoplatform.wiki.model.Page"), 166);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePage", "org.exoplatform.wiki.storage.NoteDataStorage", "java.lang.String", "pageId", "org.exoplatform.wiki.WikiException", "void"), 286);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePage", "org.exoplatform.wiki.storage.NoteDataStorage", "java.lang.String:java.lang.String:java.lang.String", "wikiType:wikiOwner:pageName", "org.exoplatform.wiki.WikiException", "void"), 292);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "renamePage", "org.exoplatform.wiki.storage.NoteDataStorage", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "wikiType:wikiOwner:pageName:newName:newTitle", "org.exoplatform.wiki.WikiException", "void"), 345);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "movePage", "org.exoplatform.wiki.storage.NoteDataStorage", "org.exoplatform.wiki.service.WikiPageParams:org.exoplatform.wiki.service.WikiPageParams", "currentLocationParams:newLocationParams", "org.exoplatform.wiki.WikiException", "void"), 371);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addPageVersion", "org.exoplatform.wiki.storage.NoteDataStorage", "org.exoplatform.wiki.model.Page:java.lang.String", "page:userName", "org.exoplatform.wiki.WikiException", "org.exoplatform.wiki.model.PageVersion"), 704);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updatePage", "org.exoplatform.wiki.storage.NoteDataStorage", "org.exoplatform.wiki.model.Page", "page", "org.exoplatform.wiki.WikiException", "org.exoplatform.wiki.model.Page"), 783);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteVersionsByNoteIdAndLang", "org.exoplatform.wiki.storage.NoteDataStorage", "java.lang.Long:java.lang.String", "noteId:lang", "org.exoplatform.wiki.WikiException", "void"), 941);
    }
}

