/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.plugin;

import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.plugin.WikiPageAttachmentPlugin;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WikiPageAttachmentPluginTest {
    @Mock
    private NoteService noteService;
    @Mock
    private SpaceService spaceService;
    private WikiPageAttachmentPlugin plugin;

    @Before
    public void setUp() {
        this.plugin = new WikiPageAttachmentPlugin(this.noteService, this.spaceService);
    }

    @Test
    public void testGetObjectType() {
        Assert.assertEquals((Object)"wikiPage", (Object)this.plugin.getObjectType());
    }

    @Test
    public void testHasAccessPermission() throws Exception {
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)page.isCanView()).thenReturn((Object)true);
        Mockito.when((Object)this.noteService.getNoteById("1", userIdentity)).thenReturn((Object)page);
        Assert.assertTrue((boolean)this.plugin.hasAccessPermission(userIdentity, "1"));
    }

    @Test
    public void testHasEditPermission() throws Exception {
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)this.noteService.getNoteById("1", userIdentity)).thenReturn((Object)page);
        Mockito.when((Object)page.isCanManage()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.plugin.hasEditPermission(userIdentity, "1"));
    }

    @Test
    public void getSpaceId() throws Exception {
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)page.getWikiOwner()).thenReturn((Object)"spaces/test2");
        Mockito.when((Object)this.noteService.getNoteById(ArgumentMatchers.anyString())).thenReturn((Object)page);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)space.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(page.getWikiOwner())).thenReturn((Object)space);
        Assert.assertEquals((long)1L, (long)this.plugin.getSpaceId("1"));
    }
}

