/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.plugin;

import io.meeds.gamification.plugin.EventPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class NoteEventPlugin
extends EventPlugin {
    public static final String EVENT_TYPE = "note";
    public static final String GAMIFICATION_WIKI_ADD_PAGE = "addWikiPage";
    public static final String GAMIFICATION_WIKI_UPDATE_PAGE = "updateWikiPage";

    public String getEventType() {
        return EVENT_TYPE;
    }

    public List<String> getTriggers() {
        return List.of(GAMIFICATION_WIKI_ADD_PAGE, GAMIFICATION_WIKI_UPDATE_PAGE);
    }

    public boolean isValidEvent(Map<String, String> eventProperties, String triggerDetails) {
        List desiredSpaceIds = eventProperties.get("spaceIds") != null ? Arrays.asList(eventProperties.get("spaceIds").split(",")) : Collections.emptyList();
        Map<String, String> triggerDetailsMop = NoteEventPlugin.stringToMap(triggerDetails);
        return CollectionUtils.isNotEmpty(desiredSpaceIds) && desiredSpaceIds.contains(triggerDetailsMop.get("spaceId"));
    }

    private static Map<String, String> stringToMap(String mapAsString) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        mapAsString = mapAsString.substring(1, mapAsString.length() - 1);
        for (String pair : pairs = mapAsString.split(", ")) {
            String[] keyValue = pair.split(": ");
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            map.put(key, value);
        }
        return map;
    }
}

