/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.listener;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.listener.MetadataItemModified;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MetadataItemModifiedTest {
    @Mock
    private IndexingService indexingService;
    @Mock
    private NoteService noteService;
    @Mock
    private CachedActivityStorage activityStorage;

    @Test
    public void testNoInteractionWhenMetadataNotForNews() throws Exception {
        MetadataItemModified metadataItemModified = new MetadataItemModified(this.noteService, this.indexingService, (ActivityStorage)this.activityStorage);
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        Event event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)((MetadataItem)event.getData())).thenReturn((Object)metadataItem);
        Mockito.when((Object)((MetadataItem)event.getData()).getObjectType()).thenReturn((Object)"activity");
        Mockito.when((Object)metadataItem.getObjectId()).thenReturn((Object)"1");
        metadataItemModified.onEvent(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.noteService});
    }

    @Test
    public void testReindexNoteWhenNoteSetAsFavorite() throws Exception {
        MetadataItemModified metadataItemModified = new MetadataItemModified(this.noteService, this.indexingService, (ActivityStorage)this.activityStorage);
        String pageId = "100";
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        Mockito.when((Object)metadataItem.getObjectType()).thenReturn((Object)"notes");
        Mockito.when((Object)metadataItem.getObjectId()).thenReturn((Object)pageId);
        Event event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)((MetadataItem)event.getData())).thenReturn((Object)metadataItem);
        Page page = new Page();
        page.setId(pageId);
        Mockito.when((Object)this.noteService.getNoteById(pageId)).thenReturn((Object)page);
        metadataItemModified.onEvent(event);
        ((NoteService)Mockito.verify((Object)this.noteService, (VerificationMode)Mockito.times((int)1))).getNoteById(pageId);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).reindex("wiki-page", pageId);
    }

    @Test
    public void testReindexNoteVersionLangWhenSetAsFavorite() throws Exception {
        MetadataItemModified metadataItemModified = new MetadataItemModified(this.noteService, this.indexingService, (ActivityStorage)this.activityStorage);
        String pageId = "100-en";
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        Mockito.when((Object)metadataItem.getObjectType()).thenReturn((Object)"notes");
        Mockito.when((Object)metadataItem.getObjectId()).thenReturn((Object)pageId);
        Event event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)((MetadataItem)event.getData())).thenReturn((Object)metadataItem);
        metadataItemModified.onEvent(event);
        ((NoteService)Mockito.verify((Object)this.noteService, (VerificationMode)Mockito.times((int)0))).getNoteById(pageId);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).reindex("note-version", pageId);
    }

    @Test
    public void testCleanPageActivityCacheWhenMarkAsFavorite() throws Exception {
        MetadataItemModified metadataItemModified = new MetadataItemModified(this.noteService, this.indexingService, (ActivityStorage)this.activityStorage);
        String pageId = "200";
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        Mockito.when((Object)metadataItem.getObjectType()).thenReturn((Object)"notes");
        Mockito.when((Object)metadataItem.getObjectId()).thenReturn((Object)pageId);
        Event event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)((MetadataItem)event.getData())).thenReturn((Object)metadataItem);
        String activityId = "activityId";
        Page page = new Page();
        page.setId(pageId);
        page.setActivityId(activityId);
        Mockito.when((Object)this.noteService.getNoteById(pageId)).thenReturn((Object)page);
        metadataItemModified.onEvent(event);
        ((NoteService)Mockito.verify((Object)this.noteService, (VerificationMode)Mockito.times((int)1))).getNoteById(pageId);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).reindex("wiki-page", pageId);
        ((CachedActivityStorage)Mockito.verify((Object)this.activityStorage, (VerificationMode)Mockito.times((int)1))).clearActivityCached(activityId);
    }
}

