/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import java.util.Date;
import java.util.List;
import org.exoplatform.wiki.jpa.BaseWikiJPAIntegrationTest;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.PageVersionEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.junit.Test;

public class PageVersionDAOTest
extends BaseWikiJPAIntegrationTest {
    @Test
    public void testLastversionNumberOfPage() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity parentPage = new PageEntity();
        parentPage.setWiki(wiki);
        parentPage.setName("parentPage1");
        parentPage.setCreatedDate(new Date());
        parentPage.setUpdatedDate(new Date());
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setParentPage(parentPage);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        this.pageDAO.create((Object)parentPage);
        this.pageDAO.create((Object)page);
        PageVersionEntity pageVersion1 = new PageVersionEntity();
        pageVersion1.setPage(page);
        pageVersion1.setName("1");
        pageVersion1.setCreatedDate(new Date());
        pageVersion1.setUpdatedDate(new Date());
        pageVersion1.setVersionNumber(1L);
        this.pageVersionDAO.create((Object)pageVersion1);
        PageVersionEntity pageVersion2 = new PageVersionEntity();
        pageVersion2.setPage(page);
        pageVersion2.setName("2");
        pageVersion2.setCreatedDate(new Date());
        pageVersion2.setUpdatedDate(new Date());
        pageVersion2.setVersionNumber(2L);
        this.pageVersionDAO.create((Object)pageVersion2);
        PageVersionDAOTest.assertEquals((long)2L, (long)this.pageVersionDAO.getLastversionNumberOfPage(Long.valueOf(page.getId())));
    }

    @Test
    public void testPageversionByPageIdAndVersion() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity parentPage = new PageEntity();
        parentPage.setWiki(wiki);
        parentPage.setName("parentPage1");
        parentPage.setCreatedDate(new Date());
        parentPage.setUpdatedDate(new Date());
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setParentPage(parentPage);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        this.pageDAO.create((Object)parentPage);
        this.pageDAO.create((Object)page);
        PageVersionEntity pageVersion1 = new PageVersionEntity();
        pageVersion1.setPage(page);
        pageVersion1.setName("1");
        pageVersion1.setCreatedDate(new Date());
        pageVersion1.setUpdatedDate(new Date());
        pageVersion1.setVersionNumber(1L);
        pageVersion1.setContent("Content Version 1");
        this.pageVersionDAO.create((Object)pageVersion1);
        PageVersionEntity pageVersion2 = new PageVersionEntity();
        pageVersion2.setPage(page);
        pageVersion2.setName("2");
        pageVersion2.setCreatedDate(new Date());
        pageVersion2.setUpdatedDate(new Date());
        pageVersion2.setVersionNumber(2L);
        pageVersion2.setContent("Content Version 2");
        this.pageVersionDAO.create((Object)pageVersion2);
        PageVersionEntity fetchedPageVersion1 = this.pageVersionDAO.getPageversionByPageIdAndVersion(Long.valueOf(page.getId()), Long.valueOf(1L));
        PageVersionEntity fetchedPageVersion2 = this.pageVersionDAO.getPageversionByPageIdAndVersion(Long.valueOf(page.getId()), Long.valueOf(2L));
        PageVersionDAOTest.assertNotNull((Object)fetchedPageVersion1);
        PageVersionDAOTest.assertEquals((String)"Content Version 1", (String)fetchedPageVersion1.getContent());
        PageVersionDAOTest.assertNotNull((Object)fetchedPageVersion2);
        PageVersionDAOTest.assertEquals((String)"Content Version 2", (String)fetchedPageVersion2.getContent());
    }

    @Test
    public void testFindPageVersionsByPageIdAndLang() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity parentPage = new PageEntity();
        parentPage.setWiki(wiki);
        parentPage.setName("parentPage1");
        parentPage.setCreatedDate(new Date());
        parentPage.setUpdatedDate(new Date());
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setParentPage(parentPage);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        this.pageDAO.create((Object)parentPage);
        this.pageDAO.create((Object)page);
        PageVersionEntity pageVersion1 = new PageVersionEntity();
        pageVersion1.setPage(page);
        pageVersion1.setName("1");
        pageVersion1.setCreatedDate(new Date());
        pageVersion1.setUpdatedDate(new Date());
        pageVersion1.setVersionNumber(1L);
        pageVersion1.setContent("Content Version 1");
        pageVersion1.setLang("fr");
        this.pageVersionDAO.create((Object)pageVersion1);
        PageVersionEntity pageVersion2 = new PageVersionEntity();
        pageVersion2.setPage(page);
        pageVersion2.setName("2");
        pageVersion2.setCreatedDate(new Date());
        pageVersion2.setUpdatedDate(new Date());
        pageVersion2.setVersionNumber(2L);
        pageVersion2.setContent("Content Version 2");
        pageVersion2.setLang("fr");
        this.pageVersionDAO.create((Object)pageVersion2);
        List fetchedPagesVersionsFr = this.pageVersionDAO.findPageVersionsByPageIdAndLang(Long.valueOf(page.getId()), "fr");
        List fetchedPagesVersionsEn = this.pageVersionDAO.findPageVersionsByPageIdAndLang(Long.valueOf(page.getId()), "en");
        PageVersionDAOTest.assertNotNull((Object)fetchedPagesVersionsFr);
        PageVersionDAOTest.assertEquals((int)2, (int)fetchedPagesVersionsFr.size());
        PageVersionDAOTest.assertNotNull((Object)fetchedPagesVersionsEn);
        PageVersionDAOTest.assertTrue((boolean)fetchedPagesVersionsEn.isEmpty());
    }
}

