/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import java.util.List;
import org.exoplatform.wiki.jpa.BaseWikiJPAIntegrationTest;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class WikiDAOTest
extends BaseWikiJPAIntegrationTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.wikiDAO.deleteAll();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.wikiDAO.deleteAll();
        super.tearDown();
    }

    @Test
    public void testFindAllIds() {
        this.wikiDAO.create((Object)new WikiEntity().setName("My wiki #1").setType("portal").setOwner("wiki1"));
        this.wikiDAO.create((Object)new WikiEntity().setName("My wiki #2").setType("portal").setOwner("wiki2"));
        List ids = this.wikiDAO.findAllIds(0, 10);
        WikiDAOTest.assertEquals((int)2, (int)ids.size());
    }

    @Test
    public void testFindWikiByTypeAndOwner() {
        this.wikiDAO.create((Object)new WikiEntity().setName("My wiki #1").setType("portal").setOwner("wiki1"));
        this.wikiDAO.create((Object)new WikiEntity().setName("My wiki #2").setType("portal").setOwner("wiki2"));
        WikiEntity wiki1 = this.wikiDAO.getWikiByTypeAndOwner("portal", "wiki1");
        WikiEntity wiki2 = this.wikiDAO.getWikiByTypeAndOwner("group", "wiki1");
        WikiEntity wiki3 = this.wikiDAO.getWikiByTypeAndOwner("portal", "wiki3");
        WikiDAOTest.assertNotNull((Object)wiki1);
        WikiDAOTest.assertNull((Object)wiki2);
        WikiDAOTest.assertNull((Object)wiki3);
    }

    @Test
    public void testFindWikisByType() {
        this.wikiDAO.create((Object)new WikiEntity().setName("My wiki #1").setType("portal").setOwner("wiki1"));
        this.wikiDAO.create((Object)new WikiEntity().setName("My wiki #2").setType("portal").setOwner("wiki2"));
        this.wikiDAO.create((Object)new WikiEntity().setName("My wiki #3").setType("group").setOwner("wiki3"));
        List portalWikis = this.wikiDAO.getWikisByType("portal");
        List groupWikis = this.wikiDAO.getWikisByType("group");
        List userWikis = this.wikiDAO.getWikisByType("user");
        WikiDAOTest.assertNotNull((Object)portalWikis);
        WikiDAOTest.assertEquals((int)2, (int)portalWikis.size());
        WikiDAOTest.assertNotNull((Object)groupWikis);
        WikiDAOTest.assertEquals((int)1, (int)groupWikis.size());
        WikiDAOTest.assertNotNull((Object)userWikis);
        WikiDAOTest.assertEquals((int)0, (int)userWikis.size());
    }

    @Test
    public void testCreateWiki() {
        WikiEntity wiki1 = (WikiEntity)this.wikiDAO.create((Object)new WikiEntity().setType("portal").setOwner("wiki1"));
        WikiDAOTest.assertNotNull((Object)wiki1);
        WikiDAOTest.assertEquals((String)"portal", (String)wiki1.getType());
        WikiDAOTest.assertEquals((String)"wiki1", (String)wiki1.getOwner());
        WikiDAOTest.assertNotNull((Object)this.wikiDAO.getWikiByTypeAndOwner("portal", "wiki1"));
    }
}

