/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import java.util.Date;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.search.WikiPageIndexingServiceConnector;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.NoteService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WikiPageIndexingServiceConnectorTest {
    private static final String PAGE_ID = "223";
    @Mock
    private MetadataService metadataService;
    @Mock
    private NoteService noteService;
    @Mock
    private InitParams initParams;
    @Mock
    private PropertiesParam propertiesParam;
    @Mock
    private Page page;

    @Before
    public void setUp() {
        Mockito.when((Object)this.initParams.getPropertiesParam("constructor.params")).thenReturn((Object)this.propertiesParam);
        Mockito.when((Object)this.propertiesParam.getProperty("index_current")).thenReturn((Object)"currentIndex");
        Mockito.when((Object)this.propertiesParam.getProperty("index_alias")).thenReturn((Object)"currentAlias");
        Mockito.when((Object)this.page.getWikiType()).thenReturn((Object)"group");
        Mockito.when((Object)this.page.getWikiOwner()).thenReturn((Object)"owner");
        Mockito.when((Object)this.page.getCreatedDate()).thenReturn((Object)new Date());
        Mockito.when((Object)this.page.getUpdatedDate()).thenReturn((Object)new Date());
    }

    @Test
    public void testCreateNoteIndex() throws WikiException {
        WikiPageIndexingServiceConnector indexingServiceConnector = new WikiPageIndexingServiceConnector(this.initParams, this.noteService, this.metadataService);
        Assert.assertNull((Object)indexingServiceConnector.create(PAGE_ID));
        Mockito.when((Object)this.noteService.getNoteById(PAGE_ID)).thenReturn((Object)this.page);
        Assert.assertNotNull((Object)indexingServiceConnector.create(PAGE_ID));
        Mockito.when((Object)this.page.getOwner()).thenReturn((Object)IdentityConstants.SYSTEM);
        Assert.assertNull((Object)indexingServiceConnector.create(PAGE_ID));
    }

    @Test
    public void testUpdateNoteIndex() throws WikiException {
        WikiPageIndexingServiceConnector indexingServiceConnector = new WikiPageIndexingServiceConnector(this.initParams, this.noteService, this.metadataService);
        Assert.assertNull((Object)indexingServiceConnector.update(PAGE_ID));
        Mockito.when((Object)this.noteService.getNoteById(PAGE_ID)).thenReturn((Object)this.page);
        Assert.assertNotNull((Object)indexingServiceConnector.update(PAGE_ID));
        Mockito.when((Object)this.page.getOwner()).thenReturn((Object)IdentityConstants.SYSTEM);
        Assert.assertNull((Object)indexingServiceConnector.update(PAGE_ID));
    }
}

