/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.listener;

import java.util.HashSet;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.perkstore.model.GlobalSettings;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.PerkStoreWebSocketService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

@Asynchronous
public class WebSocketProductListener
extends Listener<Product, Boolean> {
    private PerkStoreWebSocketService webSocketService;
    private PerkStoreService perkStoreService;

    public void onEvent(Event<Product, Boolean> event) throws Exception {
        Product product = (Product)event.getSource();
        if (!product.isEnabled()) {
            return;
        }
        HashSet<String> recipientUsers = new HashSet<String>();
        GlobalSettings globalSettings = this.getPerkStoreService().getGlobalSettings();
        boolean sendToAll = Utils.getProductAccessUsersList(recipientUsers, product, globalSettings);
        if (!sendToAll && product.getLastModifier() != null) {
            recipientUsers.add(product.getLastModifier().getId());
        }
        this.getWebSocketService().sendMessage(event.getEventName(), recipientUsers, sendToAll, product);
    }

    private PerkStoreWebSocketService getWebSocketService() {
        if (this.webSocketService == null) {
            this.webSocketService = (PerkStoreWebSocketService)CommonsUtils.getService(PerkStoreWebSocketService.class);
        }
        return this.webSocketService;
    }

    public PerkStoreService getPerkStoreService() {
        if (this.perkStoreService == null) {
            this.perkStoreService = (PerkStoreService)CommonsUtils.getService(PerkStoreService.class);
        }
        return this.perkStoreService;
    }
}

