/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll;

import io.meeds.kernel.test.AbstractSpringTest;
import java.util.Arrays;
import java.util.Random;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.springframework.beans.factory.annotation.Autowired;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.poll.service-local-configuration.xml")})
public abstract class BasePollTest
extends AbstractSpringTest {
    public static final String MODULE_NAME = "io.meeds.poll";
    public static final String CHANGELOG_PATH = "classpath:db/changelog/poll-rdbms.db.changelog-master.xml";
    protected static final String TESTUSER_1 = "testuser1";
    protected static final String TESTUSER_2 = "testuser2";
    protected static final String TESTUSER_3 = "testuser3";
    private static final Random RANDOM = new Random();
    @Autowired
    protected IdentityManager identityManager;
    @Autowired
    protected SpaceService spaceService;
    protected Space space;
    protected Identity user1Identity;
    protected Identity user2Identity;
    protected Identity user3Identity;

    @BeforeEach
    public void beforeEach() {
        this.begin();
        this.initUsers();
        this.injectSpace();
    }

    @AfterEach
    protected void afterEach() {
        this.end();
    }

    protected void initUsers() {
        this.user1Identity = this.identityManager.getOrCreateUserIdentity(TESTUSER_1);
        this.user2Identity = this.identityManager.getOrCreateUserIdentity(TESTUSER_2);
        this.user3Identity = this.identityManager.getOrCreateUserIdentity(TESTUSER_3);
    }

    protected void injectSpace() {
        String displayName = "testSpacePoll" + RANDOM.nextInt();
        this.space = this.spaceService.getSpaceByPrettyName(displayName);
        if (this.space == null) {
            this.space = this.createSpace(displayName, this.user1Identity.getRemoteId(), this.user2Identity.getRemoteId());
        }
        if (!this.spaceService.isMember(this.space, this.user1Identity.getRemoteId())) {
            this.spaceService.addMember(this.space, this.user1Identity.getRemoteId());
        }
    }

    protected Space createSpace(String displayName, String ... members) {
        Space newSpace = new Space();
        newSpace.setDisplayName(displayName);
        newSpace.setPrettyName(displayName);
        newSpace.setRegistration("open");
        newSpace.setVisibility("private");
        newSpace = this.spaceService.createSpace(newSpace, "root");
        if (members != null) {
            Space createdSpace = newSpace;
            Arrays.stream(members).forEach(m -> this.spaceService.addMember(createdSpace, m));
        }
        return newSpace;
    }

    public void testNop() {
    }
}

