/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeChangeQueue;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.navigation.VisitMode;

class TreeContext<N>
implements Scope.Visitor,
NodeChangeListener<NodeContext<N>> {
    private NodeChangeQueue<NodeContext<N>> changes;
    final NodeModel<N> model;
    boolean editMode;
    int sequence;
    final NodeContext<N> root;

    TreeContext(NodeModel<N> model, NodeContext<N> root) {
        this.model = model;
        this.editMode = false;
        this.sequence = 0;
        this.root = root;
    }

    public NodeChangeQueue<NodeContext<N>> getChanges() {
        return this.changes;
    }

    Scope.Visitor origin() {
        final HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        this.populate(map, this.root);
        if (this.changes != null) {
            ListIterator it = this.changes.listIterator(this.changes.size());
            while (it.hasPrevious()) {
                NodeChange change = (NodeChange)it.previous();
                if (change instanceof NodeChange.Created) {
                    NodeChange.Created created = (NodeChange.Created)change;
                    map.remove(((NodeContext)created.target).handle);
                    continue;
                }
                if (!(change instanceof NodeChange.Destroyed)) continue;
                NodeChange.Destroyed destroyed = (NodeChange.Destroyed)change;
                map.put(((NodeContext)destroyed.target).handle, Boolean.TRUE);
            }
        }
        return new Scope.Visitor(){

            @Override
            public VisitMode enter(int depth, String id, String name, NodeState state) {
                return map.containsKey(id) ? VisitMode.ALL_CHILDREN : VisitMode.NO_CHILDREN;
            }

            @Override
            public void leave(int depth, String id, String name, NodeState state) {
            }
        };
    }

    private void populate(Map<String, Boolean> map, NodeContext<N> ctx) {
        if (ctx.isExpanded()) {
            map.put(ctx.handle, Boolean.TRUE);
            for (NodeContext current = (NodeContext)ctx.getFirst(); current != null; current = (NodeContext)current.getNext()) {
                this.populate(map, current);
            }
        }
    }

    void addChange(NodeChange<NodeContext<N>> change) {
        if (this.editMode) {
            throw new AssertionError();
        }
        if (this.changes == null) {
            this.changes = new NodeChangeQueue();
        }
        if (((NodeContext)change.target).tree != this) {
            throw new AssertionError((Object)"Ensure we are not mixing badly things");
        }
        if (change instanceof NodeChange.Renamed) {
            NodeChange.Renamed renamed = (NodeChange.Renamed)change;
            ((NodeContext)renamed.target).name = renamed.name;
        } else if (change instanceof NodeChange.Created) {
            NodeChange.Created added = (NodeChange.Created)change;
            if (added.previous != null) {
                ((NodeContext)added.previous).insertAfter((NodeContext)added.target);
            } else {
                ((NodeContext)added.parent).insertAt((Integer)0, (NodeContext)added.target);
            }
        } else if (change instanceof NodeChange.Moved) {
            NodeChange.Moved moved = (NodeChange.Moved)change;
            if (moved.previous != null) {
                ((NodeContext)moved.previous).insertAfter((NodeContext)moved.target);
            } else {
                ((NodeContext)moved.to).insertAt((Integer)0, (NodeContext)moved.target);
            }
        } else if (change instanceof NodeChange.Destroyed) {
            NodeChange.Destroyed removed = (NodeChange.Destroyed)change;
            ((NodeContext)removed.target).remove();
        } else if (change instanceof NodeChange.Updated) {
            NodeChange.Updated updated = (NodeChange.Updated)change;
            ((NodeContext)updated.target).state = updated.state;
        }
        this.changes.addLast(change);
    }

    boolean hasChanges() {
        return this.changes != null && this.changes.size() > 0;
    }

    List<NodeChange<NodeContext<N>>> peekChanges() {
        if (this.hasChanges()) {
            return this.changes;
        }
        return Collections.emptyList();
    }

    List<NodeChange<NodeContext<N>>> popChanges() {
        if (this.hasChanges()) {
            NodeChangeQueue<NodeContext<N>> tmp = this.changes;
            this.changes = null;
            return tmp;
        }
        return Collections.emptyList();
    }

    NodeContext<N> getNode(String handle) {
        return this.root.getDescendant(handle);
    }

    NodeContext<N> create(String handle, String name, NodeState state) {
        return new NodeContext(this, handle, name, state, true);
    }

    @Override
    public VisitMode enter(int depth, String id, String name, NodeState state) {
        NodeContext<N> descendant = this.root.getDescendant(id);
        if (descendant != null) {
            return descendant.isExpanded() ? VisitMode.ALL_CHILDREN : VisitMode.NO_CHILDREN;
        }
        return VisitMode.NO_CHILDREN;
    }

    @Override
    public void leave(int depth, String id, String name, NodeState state) {
    }

    @Override
    public void onCreate(NodeContext<N> target, NodeContext<N> parent, NodeContext<N> previous, String name) throws NavigationServiceException {
        this.addChange(new NodeChange.Created<NodeContext<N>>(parent, previous, target, name));
    }

    @Override
    public void onDestroy(NodeContext<N> target, NodeContext<N> parent) {
        this.addChange(new NodeChange.Destroyed<NodeContext<N>>(parent, target));
    }

    @Override
    public void onRename(NodeContext<N> target, NodeContext<N> parent, String name) throws NavigationServiceException {
        this.addChange(new NodeChange.Renamed<NodeContext<N>>(parent, target, name));
    }

    @Override
    public void onUpdate(NodeContext<N> target, NodeState state) throws NavigationServiceException {
        this.addChange(new NodeChange.Updated<NodeContext<N>>(target, state));
    }

    @Override
    public void onMove(NodeContext<N> target, NodeContext<N> from, NodeContext<N> to, NodeContext<N> previous) throws NavigationServiceException {
        this.addChange(new NodeChange.Moved<NodeContext<N>>(from, to, previous, target));
    }

    @Override
    public void onAdd(NodeContext<N> target, NodeContext<N> parent, NodeContext<N> previous) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onRemove(NodeContext<N> target, NodeContext<N> parent) {
        throw new UnsupportedOperationException();
    }
}

