/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.spi.portlet;

import java.util.List;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;

public class PortletBuilder {
    private Portlet prefs;

    public PortletBuilder() {
        this.prefs = new Portlet();
    }

    public PortletBuilder(Portlet that) {
        Portlet prefs = new Portlet();
        prefs.state.putAll(that.state);
        this.prefs = prefs;
    }

    public PortletBuilder add(Preference preference) {
        if (preference == null) {
            throw new NullPointerException();
        }
        this.prefs.state.put(preference.getName(), preference);
        return this;
    }

    public PortletBuilder add(String name, List<String> values, boolean readOnly) {
        return this.add(new Preference(name, values, readOnly));
    }

    public PortletBuilder add(String name, List<String> values) {
        return this.add(new Preference(name, values, false));
    }

    public PortletBuilder add(String name, String value, boolean readOnly) {
        return this.add(new Preference(name, value, readOnly));
    }

    public PortletBuilder add(String name, String value) {
        return this.add(name, value, false);
    }

    public PortletBuilder remove(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.prefs.state.remove(name);
        return this;
    }

    public PortletBuilder clear() {
        this.prefs.state.clear();
        return this;
    }

    public Portlet build() {
        Portlet tmp = this.prefs;
        this.prefs = new Portlet();
        return tmp;
    }
}

