/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop;

import java.io.Serializable;
import lombok.Generated;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageKey;

public final class SiteKey
implements Serializable {
    private static final long serialVersionUID = -33198391360501633L;
    private final SiteType type;
    private final String name;

    public SiteKey(SiteType type, String name) {
        if (type == null) {
            throw new NullPointerException("No null type can be provided");
        }
        if (name == null) {
            throw new NullPointerException("No null name can be provided");
        }
        this.type = type;
        this.name = name;
    }

    public SiteKey(String type, String name) {
        if (PortalConfig.PORTAL_TYPE.equalsIgnoreCase(type)) {
            this.type = SiteType.PORTAL;
        } else if (PortalConfig.GROUP_TYPE.equalsIgnoreCase(type)) {
            this.type = SiteType.GROUP;
        } else if (PortalConfig.GROUP_TEMPLATE.equalsIgnoreCase(type)) {
            this.type = SiteType.GROUP_TEMPLATE;
        } else if (PortalConfig.PORTAL_TEMPLATE.equalsIgnoreCase(type)) {
            this.type = SiteType.PORTAL_TEMPLATE;
        } else if (PortalConfig.SPACE_TYPE.equalsIgnoreCase(type)) {
            this.type = SiteType.SPACE;
        } else if (PortalConfig.USER_TYPE.equalsIgnoreCase(type)) {
            this.type = SiteType.USER;
        } else {
            throw new NullPointerException("No null name can be provided");
        }
        this.name = name;
    }

    public static SiteKey portal(String name) {
        return new SiteKey(SiteType.PORTAL, name);
    }

    public static SiteKey group(String name) {
        return new SiteKey(SiteType.GROUP, name);
    }

    public static SiteKey user(String name) {
        return new SiteKey(SiteType.USER, name);
    }

    public static SiteKey space(String name) {
        return new SiteKey(SiteType.SPACE, name);
    }

    public static SiteKey groupTemplate(String name) {
        return new SiteKey(SiteType.GROUP_TEMPLATE, name);
    }

    public static SiteKey portalTemplate(String name) {
        return new SiteKey(SiteType.PORTAL_TEMPLATE, name);
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public PageKey page(String name) {
        return new PageKey(this, name);
    }

    @Generated
    public SiteType getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiteKey)) {
            return false;
        }
        SiteKey other = (SiteKey)o;
        SiteType this$type = this.getType();
        SiteType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SiteType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SiteKey(type=" + String.valueOf((Object)this.getType()) + ", name=" + this.getName() + ")";
    }
}

