/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.serialize;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.portal.config.model.LocalizedString;
import org.jibx.runtime.IAliasable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.JiBXParseException;
import org.jibx.runtime.impl.UnmarshallingContext;

public class LocalizedValueMapper
implements IUnmarshaller,
IAliasable,
IMarshaller {
    private String marshalURI;
    private String marshallName;
    private static final Pattern RFC1766_PATTERN = Pattern.compile("^([a-zA-Z]{2})(?:-([a-zA-Z]{2}))?$");

    public LocalizedValueMapper(String uri, int index, String name) {
        this.marshalURI = uri;
        this.marshallName = name;
    }

    public LocalizedValueMapper() {
        this.marshalURI = null;
        this.marshallName = "label";
    }

    public boolean isPresent(IUnmarshallingContext ctx) throws JiBXException {
        return ctx.isAt(this.marshalURI, this.marshallName);
    }

    public Object unmarshal(Object o, IUnmarshallingContext ictx) throws JiBXException {
        UnmarshallingContext ctx = (UnmarshallingContext)ictx;
        if (!ctx.isAt(this.marshalURI, this.marshallName)) {
            ctx.throwStartTagNameError(this.marshalURI, this.marshallName);
        }
        int count = ctx.getAttributeCount();
        Locale lang = null;
        for (int i = 0; i < count; ++i) {
            String attrName = ctx.getAttributeName(i);
            if (!attrName.equals("xml:lang") && !attrName.equals("lang")) continue;
            String attrValue = ctx.getAttributeValue(i).trim();
            Matcher matcher = RFC1766_PATTERN.matcher(attrValue);
            if (matcher.matches()) {
                String langISO = matcher.group(1);
                String countryISO = matcher.group(2);
                if (countryISO == null) {
                    lang = new Locale(langISO.toLowerCase());
                    break;
                }
                lang = new Locale(langISO.toLowerCase(), countryISO.toLowerCase());
                break;
            }
            throw new JiBXParseException("The attribute xml:lang " + attrValue + " does not represent a valid language as defined by RFC 1766", attrValue);
        }
        ctx.parsePastStartTag(this.marshalURI, this.marshallName);
        String value = ctx.getText();
        ctx.parsePastEndTag(this.marshalURI, this.marshallName);
        return new LocalizedString(value, lang);
    }

    public boolean isExtension(String s) {
        throw new UnsupportedOperationException();
    }

    public void marshal(Object o, IMarshallingContext iMarshallingContext) throws JiBXException {
        throw new UnsupportedOperationException();
    }
}

