/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.mop;

import java.io.InputStream;
import junit.framework.TestCase;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.UnmarshalledObject;

public class PageParsingTest
extends TestCase {
    public void testParsePage() {
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("page.xml");){
            UnmarshalledObject obj = ModelUnmarshaller.unmarshall(Page.class, (InputStream)inputStream);
            Page page = (Page)obj.getObject();
            PageParsingTest.assertNotNull((Object)page);
            PageParsingTest.assertEquals((int)1, (int)page.getChildren().size());
            Container sectionsParent = (Container)page.getChildren().get(0);
            PageParsingTest.assertEquals((String)"system:/groovy/portal/webui/container/UIPageLayout.gtmpl", (String)sectionsParent.getTemplate());
            PageParsingTest.assertEquals((int)2, (int)sectionsParent.getChildren().size());
            Container columnsSection = (Container)sectionsParent.getChildren().get(0);
            PageParsingTest.assertEquals((int)2, (int)columnsSection.getChildren().size());
            PageParsingTest.assertEquals((String)"FlexContainer", (String)columnsSection.getTemplate());
            PageParsingTest.assertNotNull((Object)columnsSection.getCssClass());
            String cssClasses = columnsSection.getCssClass();
            PageParsingTest.assertTrue((String)("'grid-cols-md-12' not found in:" + cssClasses), (boolean)cssClasses.contains("grid-cols-md-12"));
            PageParsingTest.assertTrue((String)("'grid-cols-lg-12' not found in:" + cssClasses), (boolean)cssClasses.contains("grid-cols-lg-12"));
            PageParsingTest.assertTrue((String)("'grid-cols-xl-12' not found in:" + cssClasses), (boolean)cssClasses.contains("grid-cols-xl-12"));
            PageParsingTest.assertTrue((String)("'layout-mobile-columns' not found in:" + cssClasses), (boolean)cssClasses.contains("layout-mobile-columns"));
            PageParsingTest.assertTrue((String)("'layout-sticky-application' not found in:" + cssClasses), (boolean)cssClasses.contains("layout-sticky-application"));
            PageParsingTest.assertFalse((String)("'grid-rows' should not be present in:" + cssClasses), (boolean)cssClasses.contains("grid-rows"));
            PageParsingTest.assertTrue((String)("'TEST-columns-section-class' not found in:" + cssClasses), (boolean)cssClasses.contains("TEST-columns-section-class"));
            Container column = (Container)columnsSection.getChildren().get(0);
            PageParsingTest.assertEquals((int)2, (int)column.getChildren().size());
            PageParsingTest.assertEquals((String)"CellContainer", (String)column.getTemplate());
            PageParsingTest.assertNotNull((Object)column.getCssClass());
            PageParsingTest.assertTrue((String)"'flex-cell' not found", (boolean)column.getCssClass().contains("flex-cell"));
            PageParsingTest.assertTrue((String)"'grid-cell-colspan-md-9' not found", (boolean)column.getCssClass().contains("grid-cell-colspan-md-9"));
            PageParsingTest.assertTrue((String)"'grid-cell-colspan-lg-9' not found", (boolean)column.getCssClass().contains("grid-cell-colspan-lg-9"));
            PageParsingTest.assertTrue((String)"'grid-cell-colspan-xl-9' not found", (boolean)column.getCssClass().contains("grid-cell-colspan-xl-9"));
            PageParsingTest.assertTrue((String)"'grid-cell-rowspan-md-1' not found", (boolean)column.getCssClass().contains("grid-cell-rowspan-md-1"));
            PageParsingTest.assertTrue((String)"'grid-cell-rowspan-lg-1' not found", (boolean)column.getCssClass().contains("grid-cell-rowspan-lg-1"));
            PageParsingTest.assertTrue((String)"'grid-cell-rowspan-xl-1' not found", (boolean)column.getCssClass().contains("grid-cell-rowspan-xl-1"));
            PageParsingTest.assertTrue((String)"'TEST-column-class' custom class not found", (boolean)column.getCssClass().contains("TEST-column-class"));
            Application columnApplication = (Application)column.getChildren().get(0);
            PageParsingTest.assertNotNull((Object)columnApplication.getCssClass());
            PageParsingTest.assertTrue((String)("'mt-n1' not found in: " + columnApplication.getCssClass()), (boolean)columnApplication.getCssClass().contains("mt-n1"));
            PageParsingTest.assertTrue((String)("'mb-n3' not found in: " + columnApplication.getCssClass()), (boolean)columnApplication.getCssClass().contains("mb-n3"));
            PageParsingTest.assertTrue((String)"'me-n4' not found", (boolean)columnApplication.getCssClass().contains("me-n4"));
            PageParsingTest.assertTrue((String)"'ms-n5' not found", (boolean)columnApplication.getCssClass().contains("ms-n5"));
            PageParsingTest.assertTrue((String)"'brtr-4' not found", (boolean)columnApplication.getCssClass().contains("brtr-4"));
            PageParsingTest.assertTrue((String)"'brtl-2' not found", (boolean)columnApplication.getCssClass().contains("brtl-2"));
            PageParsingTest.assertTrue((String)"'brbr-1' not found", (boolean)columnApplication.getCssClass().contains("brbr-1"));
            PageParsingTest.assertTrue((String)"'brbl-0' not found", (boolean)columnApplication.getCssClass().contains("brbl-0"));
            PageParsingTest.assertTrue((String)"'hidden-sm-and-down' not found", (boolean)columnApplication.getCssClass().contains("hidden-sm-and-down"));
            PageParsingTest.assertTrue((boolean)(column.getChildren().get(1) instanceof Container));
            Container gridSection = (Container)sectionsParent.getChildren().get(1);
            PageParsingTest.assertEquals((int)3, (int)gridSection.getChildren().size());
            PageParsingTest.assertEquals((String)"GridContainer", (String)gridSection.getTemplate());
            PageParsingTest.assertNotNull((Object)gridSection.getCssClass());
            PageParsingTest.assertTrue((String)"'grid-cols-md-4' not found", (boolean)gridSection.getCssClass().contains("grid-cols-md-4"));
            PageParsingTest.assertTrue((String)"'grid-cols-lg-4' not found", (boolean)gridSection.getCssClass().contains("grid-cols-lg-4"));
            PageParsingTest.assertTrue((String)"'grid-cols-xl-4' not found", (boolean)gridSection.getCssClass().contains("grid-cols-xl-4"));
            PageParsingTest.assertTrue((String)"'grid-rows-md-2' not found", (boolean)gridSection.getCssClass().contains("grid-rows-md-2"));
            PageParsingTest.assertTrue((String)"'grid-rows-lg-2' not found", (boolean)gridSection.getCssClass().contains("grid-rows-lg-2"));
            PageParsingTest.assertTrue((String)"'grid-rows-xl-2' not found", (boolean)gridSection.getCssClass().contains("grid-rows-xl-2"));
            PageParsingTest.assertTrue((String)"'TEST-grid-section-class' not found", (boolean)gridSection.getCssClass().contains("TEST-grid-section-class"));
            Container cell = (Container)gridSection.getChildren().get(0);
            PageParsingTest.assertEquals((int)1, (int)cell.getChildren().size());
            PageParsingTest.assertEquals((String)"CellContainer", (String)cell.getTemplate());
            PageParsingTest.assertNotNull((Object)cell.getCssClass());
            PageParsingTest.assertTrue((String)"'grid-cell' not found", (boolean)cell.getCssClass().contains("grid-cell"));
            PageParsingTest.assertTrue((String)"'grid-cell-colspan-md-2' not found", (boolean)cell.getCssClass().contains("grid-cell-colspan-md-2"));
            PageParsingTest.assertTrue((String)"'grid-cell-colspan-lg-2' not found", (boolean)cell.getCssClass().contains("grid-cell-colspan-lg-2"));
            PageParsingTest.assertTrue((String)"'grid-cell-colspan-xl-2' not found", (boolean)cell.getCssClass().contains("grid-cell-colspan-xl-2"));
            PageParsingTest.assertTrue((String)"'grid-cell-rowspan-md-3' not found", (boolean)cell.getCssClass().contains("grid-cell-rowspan-md-3"));
            PageParsingTest.assertTrue((String)"'grid-cell-rowspan-lg-3' not found", (boolean)cell.getCssClass().contains("grid-cell-rowspan-lg-3"));
            PageParsingTest.assertTrue((String)"'grid-cell-rowspan-xl-3' not found", (boolean)cell.getCssClass().contains("grid-cell-rowspan-xl-3"));
            PageParsingTest.assertTrue((String)"'TEST-grid-cell-class' custom class not found", (boolean)cell.getCssClass().contains("TEST-grid-cell-class"));
            PageParsingTest.assertTrue((String)"'mt-n5' not found", (boolean)cell.getCssClass().contains("mt-n5"));
            PageParsingTest.assertTrue((String)"'mb-n4' not found", (boolean)cell.getCssClass().contains("mb-n4"));
            PageParsingTest.assertTrue((String)"'me-n3' not found", (boolean)cell.getCssClass().contains("me-n3"));
            PageParsingTest.assertTrue((String)"'ms-n1' not found", (boolean)cell.getCssClass().contains("ms-n1"));
            PageParsingTest.assertTrue((String)"'brtr-0' not found", (boolean)cell.getCssClass().contains("brtr-0"));
            PageParsingTest.assertTrue((String)"'brtl-1' not found", (boolean)cell.getCssClass().contains("brtl-1"));
            PageParsingTest.assertTrue((String)"'brbr-2' not found", (boolean)cell.getCssClass().contains("brbr-2"));
            PageParsingTest.assertTrue((String)"'brbl-4' not found", (boolean)cell.getCssClass().contains("brbl-4"));
            PageParsingTest.assertTrue((String)"'hidden-sm-and-down' not found", (boolean)cell.getCssClass().contains("hidden-sm-and-down"));
        }
    }
}

