/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.pom.data.MappedAttributes;
import org.gatein.mop.api.workspace.Navigation;

public class NavigationData
implements Serializable {
    public static final NavigationData NULL_OBJECT = new NavigationData();
    private static final long serialVersionUID = 6835338087157729952L;
    final SiteKey key;
    final NavigationState state;
    final String rootId;

    private NavigationData() {
        this.key = null;
        this.state = null;
        this.rootId = null;
    }

    public NavigationData(SiteKey key, Navigation node) {
        String rootId = node.getObjectId();
        NavigationState state = new NavigationState((Integer)node.getAttributes().getValue(MappedAttributes.PRIORITY, (Object)1));
        this.key = key;
        this.state = state;
        this.rootId = rootId;
    }

    public NavigationData(SiteKey key, NavigationState state, String rootId) {
        this.key = key;
        this.state = state;
        this.rootId = rootId;
    }

    public NavigationState getState() {
        return this.state;
    }

    public String getRootId() {
        return this.rootId;
    }

    public SiteKey getSiteKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NavigationData)) {
            return false;
        }
        NavigationData that = (NavigationData)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.rootId, (CharSequence)that.rootId);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.rootId != null ? this.rootId.hashCode() : 0);
        return result;
    }

    public boolean isNull() {
        return this.key == null && this.state == null && this.rootId == null;
    }
}

