/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeFilter;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.TreeContext;
import org.exoplatform.portal.tree.list.ListTree;

public final class NodeContext<N>
extends ListTree<NodeContext<N>> {
    final TreeContext<N> tree;
    final N node;
    String handle;
    NodeData data;
    String name;
    NodeState state;
    private boolean hidden;
    private int hiddenCount;
    private boolean expanded;
    private Collection<N> nodes;

    NodeContext(NodeModel<N> model, NodeData data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.handle = data.id;
        this.name = null;
        this.tree = new TreeContext<N>(model, this);
        this.node = this.tree.model.create(this);
        this.data = data;
        this.state = null;
        this.hidden = false;
        this.hiddenCount = 0;
        this.expanded = false;
    }

    private NodeContext(TreeContext<N> tree, NodeData data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.handle = data.id;
        this.name = null;
        this.tree = tree;
        this.node = tree.model.create(this);
        this.data = data;
        this.state = null;
        this.hidden = false;
        this.hiddenCount = 0;
        this.expanded = false;
    }

    NodeContext(TreeContext<N> tree, String handle, String name, NodeState state, boolean expanded) {
        if (handle == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        this.handle = handle;
        this.name = name;
        this.tree = tree;
        this.node = tree.model.create(this);
        this.data = null;
        this.state = state;
        this.hidden = false;
        this.hiddenCount = 0;
        this.expanded = expanded;
    }

    public boolean hasChanges() {
        return this.tree.hasChanges();
    }

    public List<NodeChange<NodeContext<N>>> getChanges() {
        return Collections.unmodifiableList(this.tree.getChanges());
    }

    public N getNode() {
        return this.node;
    }

    public String getId() {
        return this.data != null ? this.data.getId() : null;
    }

    public int getIndex() {
        int count = 0;
        for (NodeContext node = (NodeContext)this.getPrevious(); node != null; node = (NodeContext)node.getPrevious()) {
            ++count;
        }
        return count;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    void expand() {
        if (this.expanded) {
            throw new IllegalStateException("Context is already expanded");
        }
        this.expanded = true;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        if (this.hidden != hidden) {
            NodeContext parent = (NodeContext)this.getParent();
            if (parent != null) {
                parent.hiddenCount = hidden ? ++parent.hiddenCount : --parent.hiddenCount;
            }
            this.hidden = hidden;
        }
    }

    public NodeState getState() {
        if (this.state != null) {
            return this.state;
        }
        return this.data.getState();
    }

    public void setState(NodeState state) throws NullPointerException {
        if (state == null) {
            throw new NullPointerException("No null state accepted");
        }
        this.tree.addChange(new NodeChange.Updated(this, state));
    }

    public String getName() {
        return this.name != null ? this.name : this.data.name;
    }

    public void setName(String name) throws NullPointerException, IllegalStateException, IllegalArgumentException {
        NodeContext parent = (NodeContext)this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Cannot rename a node when its parent is not visible");
        }
        NodeContext<N> blah = parent.get(name);
        if (blah != null) {
            if (blah != this) {
                throw new IllegalArgumentException("the node " + name + " already exist");
            }
        } else {
            this.tree.addChange(new NodeChange.Renamed((NodeContext)this.getParent(), this, name));
        }
    }

    public void filter(NodeFilter filter) {
        this.setHidden(!this.accept(filter));
        if (this.expanded) {
            for (NodeContext node = (NodeContext)this.getFirst(); node != null; node = (NodeContext)node.getNext()) {
                node.filter(filter);
            }
        }
    }

    public boolean accept(NodeFilter filter) {
        return filter.accept(this.getDepth(), this.getId(), this.getName(), this.getState());
    }

    public int getDepth(NodeContext<N> ancestor) throws IllegalArgumentException, NullPointerException {
        if (ancestor == null) {
            throw new NullPointerException();
        }
        int depth = 0;
        for (NodeContext current = this; current != null; current = (NodeContext)current.getParent()) {
            if (current == ancestor) {
                return depth;
            }
            ++depth;
        }
        throw new IllegalArgumentException("Context " + String.valueOf(ancestor) + " is not an ancestor of " + String.valueOf(this));
    }

    public NodeContext<N> getDescendant(String handle) throws NullPointerException {
        if (handle == null) {
            throw new NullPointerException();
        }
        NodeContext<N> found = null;
        if (this.handle.equals(handle)) {
            found = this;
        } else if (this.expanded) {
            for (NodeContext current = (NodeContext)this.getFirst(); current != null && (found = current.getDescendant(handle)) == null; current = (NodeContext)current.getNext()) {
            }
        }
        return found;
    }

    public NodeContext<N> get(String name) throws NullPointerException, IllegalStateException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.expanded) {
            throw new IllegalStateException("No children relationship");
        }
        for (NodeContext node = (NodeContext)this.getFirst(); node != null; node = (NodeContext)node.getNext()) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public NodeContext<N> add(Integer index, String name) throws NullPointerException, IndexOutOfBoundsException, IllegalStateException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        NodeContext<N> nodeContext = new NodeContext<N>(this.tree, "seq_" + this.tree.sequence++, name, NodeState.INITIAL, true);
        this._add(index, nodeContext);
        return nodeContext;
    }

    public void add(Integer index, NodeContext<N> context) throws NullPointerException, IndexOutOfBoundsException, IllegalStateException {
        if (context == null) {
            throw new NullPointerException("No null context argument accepted");
        }
        this._add(index, context);
    }

    public NodeContext<N> insertLast(NodeData data) {
        if (data == null) {
            throw new NullPointerException("No null data argument accepted");
        }
        NodeContext<N> context = new NodeContext<N>(this.tree, data);
        this.insertLast(context);
        return context;
    }

    public NodeContext<N> insertAt(Integer index, NodeData data) {
        if (data == null) {
            throw new NullPointerException("No null data argument accepted");
        }
        NodeContext<N> context = new NodeContext<N>(this.tree, data);
        this.insertAt(index, context);
        return context;
    }

    public NodeContext<N> insertAfter(NodeData data) {
        if (data == null) {
            throw new NullPointerException("No null data argument accepted");
        }
        NodeContext<N> context = new NodeContext<N>(this.tree, data);
        this.insertAfter(context);
        return context;
    }

    private void _add(Integer index, NodeContext<N> child) {
        NodeContext previous;
        NodeContext previousParent = (NodeContext)child.getParent();
        if (index == null) {
            NodeContext before;
            for (before = (NodeContext)this.getLast(); before != null && before.isHidden(); before = (NodeContext)before.getPrevious()) {
            }
            previous = before == null ? null : before;
        } else {
            if (index < 0) {
                throw new IndexOutOfBoundsException("No negative index accepted");
            }
            if (index == 0) {
                previous = null;
            } else {
                NodeContext before = (NodeContext)this.getFirst();
                if (before == null) {
                    throw new IndexOutOfBoundsException("Index " + index + " is greater than 0");
                }
                for (int count = index.intValue(); count > 1; count -= before.isHidden() ? 0 : 1) {
                    if ((before = (NodeContext)before.getNext()) != null) continue;
                    throw new IndexOutOfBoundsException("Index " + index + " is greater than the number of children " + (index - count));
                }
                previous = before;
            }
        }
        if (previousParent != null) {
            this.tree.addChange(new NodeChange.Moved<NodeContext<N>>(previousParent, this, previous, child));
        } else {
            this.tree.addChange(new NodeChange.Created<NodeContext<N>>(this, previous, child, child.getName()));
        }
    }

    public int getNodeSize() {
        if (this.expanded) {
            return this.getSize();
        }
        return this.data.children.length;
    }

    public int getNodeCount() {
        if (this.expanded) {
            return this.getSize() - this.hiddenCount;
        }
        return this.data.children.length;
    }

    public N getParentNode() {
        NodeContext parent = (NodeContext)this.getParent();
        return parent != null ? (N)parent.node : null;
    }

    public N getNode(String name) throws NullPointerException {
        NodeContext<N> child = this.get(name);
        return child != null && !child.hidden ? (N)child.node : null;
    }

    public N getNode(int index) {
        NodeContext context;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " cannot be negative");
        }
        if (!this.expanded) {
            throw new IllegalStateException("No children relationship");
        }
        for (context = (NodeContext)this.getFirst(); context != null && (context.hidden || index-- > 0); context = (NodeContext)context.getNext()) {
        }
        if (context == null) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
        }
        return context.node;
    }

    public N getDescendantNode(String handle) throws NullPointerException {
        NodeContext<N> descendant = this.getDescendant(handle);
        return descendant != null && !descendant.hidden ? (N)descendant.node : null;
    }

    public Iterator<N> iterator() {
        return new Iterator<N>(){
            NodeContext<N> next;
            {
                this.next = (NodeContext)NodeContext.this.getFirst();
                while (this.next != null && this.next.isHidden()) {
                    this.next = (NodeContext)this.next.getNext();
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public N next() {
                if (this.next != null) {
                    NodeContext tmp = this.next;
                    do {
                        this.next = (NodeContext)this.next.getNext();
                    } while (this.next != null && this.next.isHidden());
                    return tmp.getNode();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Collection<N> getNodes() {
        if (this.expanded) {
            if (this.nodes == null) {
                this.nodes = new AbstractCollection<N>(){

                    @Override
                    public Iterator<N> iterator() {
                        return NodeContext.this.iterator();
                    }

                    @Override
                    public int size() {
                        return NodeContext.this.getNodeCount();
                    }
                };
            }
            return this.nodes;
        }
        return null;
    }

    public boolean removeNode(String name) throws NullPointerException, IllegalArgumentException, IllegalStateException {
        NodeContext<N> node = this.get(name);
        if (node == null) {
            throw new IllegalArgumentException("Cannot remove non existent " + name + " child");
        }
        return node.removeNode();
    }

    public boolean removeNode() throws IllegalStateException {
        if (this.hidden) {
            return false;
        }
        this.tree.addChange(new NodeChange.Destroyed((NodeContext)this.getParent(), this));
        return true;
    }

    @Override
    protected void beforeRemove(NodeContext<N> context) {
        if (!this.expanded) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected void beforeInsert(NodeContext<N> context) {
        NodeContext<N> existing;
        if (!this.expanded) {
            throw new IllegalStateException("No children relationship");
        }
        if (!this.tree.editMode && (existing = this.get(context.getName())) != null && existing != context) {
            throw new IllegalArgumentException("Tree " + context.getName() + " already in the map");
        }
    }

    @Override
    protected void afterInsert(NodeContext<N> context) {
        super.afterInsert(context);
        if (context.hidden) {
            ++this.hiddenCount;
        }
    }

    @Override
    protected void afterRemove(NodeContext<N> context) {
        if (context.hidden) {
            --this.hiddenCount;
        }
        super.afterRemove(context);
    }

    public String toString() {
        return this.toString(1, new StringBuilder()).toString();
    }

    public StringBuilder toString(int depth, StringBuilder sb) {
        if (sb == null) {
            throw new NullPointerException();
        }
        if (depth < 0) {
            throw new IllegalArgumentException("Depth cannot be negative " + depth);
        }
        sb.append("NodeContext[id=").append(this.getId()).append(",name=").append(this.getName());
        if (this.expanded && depth > 0) {
            sb.append(",children={");
            for (NodeContext current = (NodeContext)this.getFirst(); current != null; current = (NodeContext)current.getNext()) {
                if (current.getPrevious() != null) {
                    sb.append(',');
                }
                current.toString(depth - 1, sb);
            }
            sb.append("}");
        } else {
            sb.append("]");
        }
        return sb;
    }
}

