/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.serialize;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ModelStyle;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.serialize.JibxArraySerialize;
import org.exoplatform.portal.config.serialize.model.Preference;
import org.exoplatform.portal.pom.data.MappedAttributes;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.jibx.runtime.IAliasable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;

public class AbstractApplicationHandler
implements IMarshaller,
IUnmarshaller,
IAliasable {
    private static final String PREFERENCES = "preferences";
    private static final String PORTLET = "portlet";
    private String mUri;
    private int mIndex;
    private String mName;

    public AbstractApplicationHandler() {
    }

    public AbstractApplicationHandler(String mUri, int mIndex, String mName) {
        this.mUri = mUri;
        this.mIndex = mIndex;
        this.mName = mName;
    }

    public boolean isExtension(String s) {
        throw new UnsupportedOperationException();
    }

    public void marshal(Object o, IMarshallingContext iMarshallingContext) throws JiBXException {
        throw new UnsupportedOperationException();
    }

    public boolean isPresent(IUnmarshallingContext ctx) throws JiBXException {
        return ctx.isAt(this.mUri, this.mName);
    }

    public Object unmarshal(Object obj, IUnmarshallingContext ictx) throws JiBXException {
        String[] stringArray;
        TransientApplicationState state;
        UnmarshallingContext ctx = (UnmarshallingContext)ictx;
        if (!ctx.isAt(this.mUri, this.mName)) {
            ctx.throwStartTagNameError(this.mUri, this.mName);
        }
        if (obj != null) {
            throw new AssertionError((Object)"That should not happen");
        }
        String id = this.optionalAttribute(ctx, "id");
        String profiles = this.optionalAttribute(ctx, "profiles");
        ctx.parsePastStartTag(this.mUri, this.mName);
        if (!ctx.isAt(this.mUri, PORTLET)) {
            return null;
        }
        ctx.parsePastStartTag(this.mUri, PORTLET);
        String applicationName = ctx.parseElementText(this.mUri, "application-ref");
        String portletName = ctx.parseElementText(this.mUri, "portlet-ref");
        String contentId = applicationName + "/" + portletName;
        Application app = Application.createPortletApplication();
        if (ctx.isAt(this.mUri, PREFERENCES)) {
            PortletBuilder builder = new PortletBuilder();
            ctx.parsePastStartTag(this.mUri, PREFERENCES);
            while (ctx.isAt(this.mUri, "preference")) {
                Preference value = (Preference)ctx.unmarshalElement();
                builder.add(value.getName(), value.getValues(), value.isReadOnly());
            }
            ctx.parsePastEndTag(this.mUri, PREFERENCES);
            state = new TransientApplicationState(contentId, builder.build());
        } else {
            state = new TransientApplicationState(contentId, null);
        }
        ctx.parsePastEndTag(this.mUri, PORTLET);
        app.setState(state);
        this.nextOptionalTag(ctx, "application-type");
        String theme = this.nextOptionalTag(ctx, "theme");
        String title = this.nextOptionalTag(ctx, "title");
        String accessPermissions = this.nextOptionalTag(ctx, "access-permissions");
        boolean showInfoBar = this.nextOptionalBooleanTag(ctx, "show-info-bar", false);
        boolean showApplicationState = this.nextOptionalBooleanTag(ctx, "show-application-state", false);
        boolean showApplicationMode = this.nextOptionalBooleanTag(ctx, "show-application-mode", false);
        String description = this.nextOptionalTag(ctx, "description");
        String icon = this.nextOptionalTag(ctx, "icon");
        String width = this.nextOptionalTag(ctx, "width");
        String height = this.nextOptionalTag(ctx, "height");
        String cssClass = this.nextOptionalTag(ctx, "cssClass");
        ModelStyle style = null;
        if (ctx.isAt(this.mUri, "css-style")) {
            style = (ModelStyle)ctx.unmarshalElement();
        }
        Properties properties = null;
        if (ctx.isAt(this.mUri, "properties")) {
            properties = (Properties)ctx.unmarshalElement();
        }
        if (StringUtils.isNotBlank((CharSequence)profiles)) {
            properties = properties == null ? new Properties() : new Properties(properties);
            properties.put(MappedAttributes.PROFILES.getName(), profiles);
        }
        ctx.parsePastEndTag(this.mUri, this.mName);
        app.setId(id);
        app.setTheme(theme);
        app.setTitle(title);
        if (StringUtils.isBlank((CharSequence)accessPermissions)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Everyone";
        } else {
            stringArray = JibxArraySerialize.deserializeStringArray(accessPermissions);
        }
        app.setAccessPermissions(stringArray);
        app.setShowInfoBar(showInfoBar);
        app.setShowApplicationState(showApplicationState);
        app.setShowApplicationMode(showApplicationMode);
        app.setDescription(description);
        app.setIcon(icon);
        app.setWidth(width);
        app.setHeight(height);
        app.setCssClass(cssClass);
        app.setProperties(properties);
        app.setCssStyle(style);
        return app;
    }

    private String optionalAttribute(UnmarshallingContext ctx, String attrName) throws JiBXException {
        String value = null;
        if (ctx.hasAttribute(this.mUri, attrName)) {
            value = ctx.attributeText(this.mUri, attrName);
        }
        return value;
    }

    private String nextOptionalTag(UnmarshallingContext ctx, String tagName) throws JiBXException {
        String value = null;
        if (ctx.isAt(this.mUri, tagName)) {
            value = ctx.parseElementText(this.mUri, tagName);
        }
        return value;
    }

    private boolean nextOptionalBooleanTag(UnmarshallingContext ctx, String tagName, boolean defaultValue) throws JiBXException {
        Boolean value = defaultValue;
        if (ctx.isAt(this.mUri, tagName)) {
            value = ctx.parseElementBoolean(this.mUri, tagName);
        }
        return value;
    }
}

