/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLResourceBundleParser {
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public static Properties asProperties(InputStream in) throws IOException, SAXException, ParserConfigurationException, IllegalArgumentException {
        if (in == null) {
            throw new IllegalArgumentException("No null input stream allowed");
        }
        return XMLResourceBundleParser.asProperties(new InputSource(in));
    }

    public static Properties asProperties(Reader in) throws IOException, SAXException, ParserConfigurationException, IllegalArgumentException {
        if (in == null) {
            throw new IllegalArgumentException("No null reader allowed");
        }
        return XMLResourceBundleParser.asProperties(new InputSource(in));
    }

    public static Properties asProperties(InputSource in) throws IOException, SAXException, ParserConfigurationException, IllegalArgumentException {
        if (in == null) {
            throw new IllegalArgumentException("No null input source allowed");
        }
        Map<String, String> bundle = XMLResourceBundleParser.asMap(in);
        Properties props = new Properties();
        props.putAll(bundle);
        return props;
    }

    public static Map<String, String> asMap(InputStream in) throws IOException, SAXException, ParserConfigurationException, IllegalArgumentException {
        if (in == null) {
            throw new IllegalArgumentException("No null input stream allowed");
        }
        return XMLResourceBundleParser.asMap(new InputSource(in));
    }

    public static Map<String, String> asMap(Reader in) throws IOException, SAXException, ParserConfigurationException, IllegalArgumentException {
        if (in == null) {
            throw new IllegalArgumentException("No null reader allowed");
        }
        return XMLResourceBundleParser.asMap(new InputSource(in));
    }

    public static Map<String, String> asMap(InputSource in) throws IOException, SAXException, ParserConfigurationException, IllegalArgumentException {
        if (in == null) {
            throw new IllegalArgumentException("No null input source allowed");
        }
        DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
        Document document = builder.parse(in);
        Element bundleElt = document.getDocumentElement();
        HashMap<String, String> bundle = new HashMap<String, String>();
        XMLResourceBundleParser.collect(new LinkedList<String>(), bundleElt, bundle);
        return bundle;
    }

    private static void collect(LinkedList<String> path, Element currentElt, Map<String, String> bundle) {
        String name;
        NodeList children = currentElt.getChildNodes();
        boolean text = true;
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            text = false;
            Element childElt = (Element)child;
            name = childElt.getTagName();
            path.addLast(name);
            XMLResourceBundleParser.collect(path, childElt, bundle);
            path.removeLast();
        }
        if (text && path.size() > 0) {
            String value = currentElt.getTextContent();
            StringBuffer sb = new StringBuffer();
            Iterator i = path.iterator();
            while (i.hasNext()) {
                name = (String)i.next();
                sb.append(name);
                if (!i.hasNext()) continue;
                sb.append('.');
            }
            String key = sb.toString();
            bundle.put(key, value);
        }
    }
}

