/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import java.util.Arrays;
import lombok.Generated;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.data.MappedAttributes;
import org.exoplatform.portal.pom.spi.portlet.Portlet;

public class Application
extends ModelObject
implements Cloneable {
    private ApplicationState state;
    private String id;
    private String title;
    private String icon;
    private String description;
    private boolean showInfoBar;
    private boolean showApplicationState = true;
    private boolean showApplicationMode = true;
    private String theme;
    private Properties properties;
    private String[] accessPermissions;

    public Application(ApplicationData data) {
        super(data.getStorageId());
        this.storageName = data.getStorageName();
        this.state = data.getState();
        this.id = data.getId();
        this.title = data.getTitle();
        this.icon = data.getIcon();
        this.description = data.getDescription();
        this.showInfoBar = data.isShowInfoBar();
        this.showApplicationState = data.isShowApplicationState();
        this.showApplicationMode = data.isShowApplicationMode();
        this.theme = data.getTheme();
        this.width = data.getWidth();
        this.height = data.getHeight();
        this.cssClass = data.getCssClass();
        this.cssStyle = data.getCssStyle();
        this.properties = new Properties(data.getProperties());
        this.accessPermissions = data.getAccessPermissions().toArray(new String[data.getAccessPermissions().size()]);
    }

    public Application(String storageId) {
        super(storageId);
    }

    public String getProfiles() {
        if (this.properties != null && this.properties.containsKey(MappedAttributes.PROFILES.getName())) {
            return (String)this.properties.get(MappedAttributes.PROFILES.getName());
        }
        return null;
    }

    public boolean getShowInfoBar() {
        return this.showInfoBar;
    }

    public void setShowInfoBar(boolean b) {
        this.showInfoBar = b;
    }

    public boolean getShowApplicationState() {
        return this.showApplicationState;
    }

    public void setShowApplicationState(boolean b) {
        this.showApplicationState = b;
    }

    public boolean getShowApplicationMode() {
        return this.showApplicationMode;
    }

    public void setShowApplicationMode(boolean b) {
        this.showApplicationMode = b;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    @Override
    public String getCssClass() {
        if (this.cssClass == null && this.cssStyle == null) {
            return null;
        }
        if (this.cssStyle == null) {
            return this.cssClass;
        }
        if (this.cssClass == null) {
            return this.cssStyle.getCssClass();
        }
        StringBuilder cssClasses = new StringBuilder();
        cssClasses.append(this.cssStyle.getCssClass(this.cssClass));
        cssClasses.append(" ");
        cssClasses.append(this.cssClass);
        return cssClasses.toString();
    }

    @Override
    public ApplicationData build() {
        return new ApplicationData(this.getStorageId(), this.getStorageName(), this.getState(), this.getId(), this.getTitle(), this.getIcon(), this.getDescription(), this.getShowInfoBar(), this.getShowApplicationState(), this.getShowApplicationMode(), this.getTheme(), this.getWidth(), this.getHeight(), this.getCssClass(), this.getCssStyle(), Utils.safeImmutableMap(this.properties), Utils.safeImmutableList(this.accessPermissions));
    }

    public static Application createPortletApplication(ApplicationData data) {
        return new Application(data);
    }

    public static Application createPortletApplication(String storageId) {
        return new Application(storageId);
    }

    public static Application createPortletApplication() {
        return new Application();
    }

    @Override
    public void checkStorage() throws ObjectNotFoundException {
        LayoutService layoutService;
        String contentId;
        if (!(this.state instanceof TransientApplicationState) && (contentId = (layoutService = (LayoutService)ExoContainerContext.getService(LayoutService.class)).getId(this.state)) == null) {
            throw new ObjectNotFoundException(String.format("Application not found with state %s", this.state));
        }
    }

    @Override
    public void resetStorage() throws ObjectNotFoundException {
        if (!(this.state instanceof TransientApplicationState)) {
            LayoutService layoutService = (LayoutService)ExoContainerContext.getService(LayoutService.class);
            Portlet preferences = layoutService.load(this.state);
            String contentId = layoutService.getId(this.state);
            if (contentId == null) {
                throw new ObjectNotFoundException(String.format("Application wasn't found with state %s", this.state));
            }
            this.state = new TransientApplicationState(contentId, preferences);
        }
        super.resetStorage();
    }

    public Application clone() {
        return new Application(this.build());
    }

    @Generated
    public ApplicationState getState() {
        return this.state;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getTheme() {
        return this.theme;
    }

    @Generated
    public String[] getAccessPermissions() {
        return this.accessPermissions;
    }

    @Generated
    public void setState(ApplicationState state) {
        this.state = state;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setTheme(String theme) {
        this.theme = theme;
    }

    @Generated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Generated
    public void setAccessPermissions(String[] accessPermissions) {
        this.accessPermissions = accessPermissions;
    }

    @Override
    @Generated
    public String toString() {
        return "Application(state=" + String.valueOf(this.getState()) + ", id=" + this.getId() + ", title=" + this.getTitle() + ", icon=" + this.getIcon() + ", description=" + this.getDescription() + ", showInfoBar=" + this.getShowInfoBar() + ", showApplicationState=" + this.getShowApplicationState() + ", showApplicationMode=" + this.getShowApplicationMode() + ", theme=" + this.getTheme() + ", properties=" + String.valueOf(this.getProperties()) + ", accessPermissions=" + Arrays.deepToString(this.getAccessPermissions()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application other = (Application)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getShowInfoBar() != other.getShowInfoBar()) {
            return false;
        }
        if (this.getShowApplicationState() != other.getShowApplicationState()) {
            return false;
        }
        if (this.getShowApplicationMode() != other.getShowApplicationMode()) {
            return false;
        }
        ApplicationState this$state = this.getState();
        ApplicationState other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$theme = this.getTheme();
        String other$theme = other.getTheme();
        if (this$theme == null ? other$theme != null : !this$theme.equals(other$theme)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        return Arrays.deepEquals(this.getAccessPermissions(), other.getAccessPermissions());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Application;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.getShowInfoBar() ? 79 : 97);
        result = result * 59 + (this.getShowApplicationState() ? 79 : 97);
        result = result * 59 + (this.getShowApplicationMode() ? 79 : 97);
        ApplicationState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $theme = this.getTheme();
        result = result * 59 + ($theme == null ? 43 : $theme.hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAccessPermissions());
        return result;
    }

    @Generated
    public Application() {
    }
}

