/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import org.exoplatform.portal.mop.navigation.NavigationError;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.TreeContext;

class TreeMerge<N>
extends NodeChangeListener.Base<NodeContext<N>> {
    private final TreeContext<N> merged;
    private final NodeChangeListener<NodeContext<N>> next;

    TreeMerge(TreeContext<N> merged, NodeChangeListener<NodeContext<N>> next) {
        this.merged = merged;
        this.next = next;
    }

    @Override
    public void onCreate(NodeContext<N> target, NodeContext<N> _parent, NodeContext<N> _previous, String name) throws NavigationServiceException {
        NodeContext<N> added;
        NodeContext<N> previous;
        String parentHandle = _parent.handle;
        NodeContext<N> parent = this.merged.getNode(parentHandle);
        if (parent == null) {
            throw new NavigationServiceException(NavigationError.ADD_CONCURRENTLY_REMOVED_PARENT_NODE);
        }
        if (_previous != null) {
            previous = this.merged.getNode(_previous.handle);
            if (previous == null) {
                throw new NavigationServiceException(NavigationError.ADD_CONCURRENTLY_REMOVED_PREVIOUS_NODE);
            }
        } else {
            previous = null;
        }
        if ((added = parent.get(name)) != null) {
            throw new NavigationServiceException(NavigationError.ADD_CONCURRENTLY_ADDED_NODE);
        }
        NodeContext<N> source = this.merged.create(target.handle, name, target.getState());
        this.next.onCreate(source, parent, previous, name);
    }

    @Override
    public void onDestroy(NodeContext<N> target, NodeContext<N> _parent) {
        NodeContext<N> removed = this.merged.getNode(target.handle);
        if (removed != null) {
            NodeContext<N> parent = this.merged.getNode(_parent.handle);
            this.next.onDestroy(removed, parent);
        }
    }

    @Override
    public void onRename(NodeContext<N> target, NodeContext<N> _parent, String _name) throws NavigationServiceException {
        String renamedHandle = target.handle;
        NodeContext<N> renamed = this.merged.getNode(renamedHandle);
        if (renamed == null) {
            throw new NavigationServiceException(NavigationError.RENAME_CONCURRENTLY_REMOVED_NODE);
        }
        NodeContext parent = (NodeContext)renamed.getParent();
        if (parent.get(_name) != null) {
            throw new NavigationServiceException(NavigationError.RENAME_CONCURRENTLY_DUPLICATE_NAME);
        }
        this.next.onRename(renamed, parent, _name);
    }

    @Override
    public void onUpdate(NodeContext<N> target, NodeState state) throws NavigationServiceException {
        String updatedHandle = target.handle;
        NodeContext<N> navigation = this.merged.getNode(updatedHandle);
        if (navigation == null) {
            throw new NavigationServiceException(NavigationError.UPDATE_CONCURRENTLY_REMOVED_NODE);
        }
        this.next.onUpdate(navigation, state);
    }

    @Override
    public void onMove(NodeContext<N> target, NodeContext<N> _from, NodeContext<N> _to, NodeContext<N> _previous) throws NavigationServiceException {
        String name;
        NodeContext<N> existing;
        NodeContext<N> previous;
        String srcHandle = _from.handle;
        NodeContext<N> src = this.merged.getNode(srcHandle);
        if (src == null) {
            throw new NavigationServiceException(NavigationError.MOVE_CONCURRENTLY_REMOVED_SRC_NODE);
        }
        String dstHandle = _to.handle;
        NodeContext<N> dst = this.merged.getNode(dstHandle);
        if (dst == null) {
            throw new NavigationServiceException(NavigationError.MOVE_CONCURRENTLY_REMOVED_DST_NODE);
        }
        String movedHandle = target.handle;
        NodeContext<N> moved = this.merged.getNode(movedHandle);
        if (moved == null) {
            throw new NavigationServiceException(NavigationError.MOVE_CONCURRENTLY_REMOVED_MOVED_NODE);
        }
        if (_previous != null) {
            previous = this.merged.getNode(_previous.handle);
            if (previous == null) {
                throw new NavigationServiceException(NavigationError.MOVE_CONCURRENTLY_REMOVED_PREVIOUS_NODE);
            }
        } else {
            previous = null;
        }
        if (src != moved.getParent()) {
            throw new NavigationServiceException(NavigationError.MOVE_CONCURRENTLY_CHANGED_SRC_NODE);
        }
        if (src != dst && (existing = dst.get(name = moved.getName())) != null) {
            throw new NavigationServiceException(NavigationError.MOVE_CONCURRENTLY_DUPLICATE_NAME);
        }
        this.next.onMove(moved, src, dst, previous);
    }
}

