/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.serialize;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class JibxArraySerialize {
    public static final String NOBODY = "Nobody";

    public static String serializeStringArray(String[] values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            String value;
            if (values[i] == null || (value = values[i].trim()).length() <= 0) continue;
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(value);
        }
        return builder.toString();
    }

    public static String[] deserializeStringArray(String text) {
        if (text == null) {
            return new String[0];
        }
        if ((text = text.trim()).length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(5);
        StringTokenizer st = new StringTokenizer(text, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String serializePermissions(String[] values) {
        if (values == null || values.length == 0) {
            return NOBODY;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            String value;
            if (values[i] == null || (value = values[i].trim()).length() <= 0) continue;
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(value);
        }
        return builder.length() == 0 ? NOBODY : builder.toString();
    }

    public static String[] deserializePermissions(String text) {
        if (text == null) {
            return new String[0];
        }
        if ((text = text.trim()).length() == 0 || NOBODY.equals(text)) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(5);
        StringTokenizer st = new StringTokenizer(text, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }
}

