/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.integration.test;

import io.meeds.spring.module.dao.TestDao;
import io.meeds.spring.module.entity.TestEntity;
import io.meeds.spring.module.model.TestModel;
import io.meeds.spring.module.service.TestExcludedService;
import io.meeds.spring.module.service.TestService;
import io.meeds.spring.module.storage.TestStorage;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.jpa.CommonsDAOJPAImplTest;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(value={CommonsDAOJPAImplTest.class})
public class SpringIntegrationTest
extends CommonsDAOJPAImplTest {
    static final String MODULE_NAME = "io.meeds.spring.module";
    static final String CHANGELOG_PATH = "classpath:db/changelog/test-rdbms.db.changelog.xml";
    @Autowired
    private SettingService settingService;
    @Autowired
    private TestDao testDao;
    @Autowired
    private TestStorage testStorage;
    @Autowired
    private TestService testService;
    @Autowired
    private TestExcludedService testExcludedService;

    @Test
    public void beansInjected() {
        SpringIntegrationTest.assertNotNull((String)"Kernel Component not found in Spring context", (Object)this.settingService);
        SpringIntegrationTest.assertNotNull((String)"Spring @Repository Bean not found", (Object)this.testDao);
        SpringIntegrationTest.assertNotNull((String)"Spring @Component Bean not found", (Object)this.testStorage);
        SpringIntegrationTest.assertNotNull((String)"Spring @Service Bean not found", (Object)this.testService);
        SpringIntegrationTest.assertNotNull((String)"Spring @Service + @Exclude Bean not found", (Object)this.testExcludedService);
    }

    @Test
    public void daoBeanReady() {
        TestEntity testEntity = (TestEntity)this.testDao.save(new TestEntity(null, "test"));
        SpringIntegrationTest.assertNotNull((Object)testEntity);
        SpringIntegrationTest.assertTrue((testEntity.getId() > 0L ? 1 : 0) != 0);
        SpringIntegrationTest.assertEquals((String)"test", (String)testEntity.getText());
    }

    @Test
    public void serviceBeanReady() {
        TestModel testModel = this.testService.save(new TestModel(null, "test2"));
        SpringIntegrationTest.assertNotNull((Object)testModel);
        SpringIntegrationTest.assertTrue((testModel.getId() > 0L ? 1 : 0) != 0);
        SpringIntegrationTest.assertEquals((String)"test2", (String)testModel.getText());
    }

    @Test
    public void daoNotRegisteredInKernel() {
        TestDao daoComponent = (TestDao)this.getContainer().getComponentInstanceOfType(TestDao.class);
        SpringIntegrationTest.assertNull((String)"DAO Layer shouldn't be accessible globally outside the curent module", (Object)daoComponent);
    }

    @Test
    public void storageNotRegisteredInKernel() {
        TestStorage testStorageComponent = (TestStorage)this.getContainer().getComponentInstanceOfType(TestStorage.class);
        SpringIntegrationTest.assertNull((String)"Service Layer should be shared globally", (Object)testStorageComponent);
    }

    @Test
    public void excludedServiceNotRegisteredInKernel() {
        TestExcludedService testExcludedServiceComponent = (TestExcludedService)this.getContainer().getComponentInstanceOfType(TestExcludedService.class);
        SpringIntegrationTest.assertNull((String)"Excluded Service Layer shouldn't be shared globally", (Object)testExcludedServiceComponent);
    }

    @Test
    public void serviceRegisteredInKernel() {
        TestService testServiceComponent = (TestService)this.getContainer().getComponentInstanceOfType(TestService.class);
        SpringIntegrationTest.assertNotNull((String)"Service Layer should be shared globally", (Object)testServiceComponent);
    }
}

