/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.CharsetTextEncoder;
import org.exoplatform.commons.utils.TextEncoder;
import org.exoplatform.component.test.AbstractGateInTest;

public class TestTextEncoder
extends AbstractGateInTest {
    public void testA() throws IOException {
        this.assertOK("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    private void assertOK(String s) throws IOException {
        TextEncoder encoder = CharsetTextEncoder.getUTF8();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        encoder.encode(s, 0, s.length(), (OutputStream)baos);
        baos.flush();
        byte[] b1 = baos.toByteArray();
        baos.reset();
        OutputStreamWriter osw = new OutputStreamWriter(baos);
        osw.write(s);
        osw.close();
        byte[] b2 = baos.toByteArray();
        List<Byte> expected = this.toList(b2);
        List<Byte> actual = this.toList(b1);
        TestTextEncoder.assertEquals(expected, actual);
    }

    private List<Byte> toList(byte[] bytes) {
        ArrayList<Byte> tmp = new ArrayList<Byte>(bytes.length);
        for (byte aByte : bytes) {
            tmp.add(aByte);
        }
        return tmp;
    }
}

