/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.exoplatform.commons.utils.CompositeReader;
import org.exoplatform.component.test.AbstractGateInTest;
import org.gatein.common.io.IOTools;

public class TestCompositeReader
extends AbstractGateInTest {
    public void testMono() {
        MyReader r = new MyReader("foo");
        CompositeReader reader = new CompositeReader(new Reader[]{r});
        this.assertEquals((Reader)reader, "foo");
        TestCompositeReader.assertTrue((boolean)r.closed);
    }

    public void testPair() {
        MyReader r1 = new MyReader("foo");
        MyReader r2 = new MyReader("bar");
        CompositeReader reader = new CompositeReader(new Reader[]{r1, r2});
        this.assertEquals((Reader)reader, "foobar");
        TestCompositeReader.assertTrue((boolean)r1.closed);
        TestCompositeReader.assertTrue((boolean)r2.closed);
    }

    public void testEmpty() {
        MyReader r1 = new MyReader("");
        MyReader r2 = new MyReader("bar");
        CompositeReader reader = new CompositeReader(new Reader[]{r1, r2});
        this.assertEquals((Reader)reader, "bar");
        r1 = new MyReader("foo");
        r2 = new MyReader("");
        reader = new CompositeReader(new Reader[]{r1, r2});
        this.assertEquals((Reader)reader, "foo");
    }

    public void testClose() throws IOException {
        MyReader r1 = new MyReader("foo");
        MyReader r2 = new MyReader("bar");
        MyReader r3 = new MyReader("juu");
        CompositeReader reader = new CompositeReader(new Reader[]{r1, r2, r3});
        reader.read(new char[4], 0, 4);
        TestCompositeReader.assertTrue((boolean)r1.closed);
        TestCompositeReader.assertFalse((boolean)r2.closed);
        TestCompositeReader.assertFalse((boolean)r3.closed);
        reader.close();
        TestCompositeReader.assertTrue((boolean)r1.closed);
        TestCompositeReader.assertTrue((boolean)r2.closed);
        TestCompositeReader.assertTrue((boolean)r3.closed);
    }

    private void assertEquals(Reader reader, String expected) {
        try {
            StringWriter writer = new StringWriter();
            IOTools.copy((Reader)reader, (Writer)writer);
            String test = writer.toString();
            TestCompositeReader.assertEquals((String)expected, (String)test);
        }
        catch (IOException e) {
            TestCompositeReader.fail((Throwable)e);
        }
    }

    private static class MyReader
    extends StringReader {
        boolean closed = false;

        private MyReader(String s) {
            super(s);
        }

        @Override
        public void close() {
            this.closed = true;
            super.close();
        }
    }
}

