/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.exoplatform.commons.utils.BinaryOutput;

public class ByteArrayOutput
implements BinaryOutput {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

    @Override
    public Charset getCharset() {
        return UTF_8;
    }

    @Override
    public void write(byte b) throws IOException {
        this.baos.write(b);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.baos.write(bytes);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.baos.write(bytes, off, len);
    }

    public byte[] getBytes() {
        return this.baos.toByteArray();
    }

    public String getString() throws UnsupportedEncodingException {
        return this.baos.toString(UTF_8.name());
    }
}

