/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageListAccess;

public class StringPageListAccess
extends PageListAccess<String, String[]> {
    public StringPageListAccess(int pageSize, String ... state) {
        super((Object)state, pageSize);
    }

    protected ListAccess<String> create(String[] state) {
        return new ArrayListAccess(state);
    }

    private static class ArrayListAccess
    implements ListAccess<String> {
        private final String[] values;

        private ArrayListAccess(String ... values) {
            this.values = values;
        }

        public String[] load(int index, int length) throws Exception {
            String[] batch = new String[length];
            System.arraycopy(this.values, index, batch, 0, length);
            return batch;
        }

        public int getSize() throws Exception {
            return this.values.length;
        }
    }
}

