/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;

public class FilteringClassLoader
extends URLClassLoader {
    private HashSet<String> filtered = new HashSet();

    public FilteringClassLoader(ClassLoader parent, URL[] urls, String[] filteredNames) {
        super(urls, parent);
        for (String name : filteredNames) {
            this.filtered.add(name);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.filtered.contains(name)) {
            Class<?> localClass = this.findLoadedClass(name);
            if (localClass == null) {
                localClass = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(localClass);
            }
            return localClass;
        }
        return super.loadClass(name, resolve);
    }
}

