/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import org.exoplatform.commons.serialization.A;
import org.exoplatform.commons.serialization.B;
import org.exoplatform.commons.serialization.D;
import org.exoplatform.commons.serialization.E1;
import org.exoplatform.commons.serialization.E2;
import org.exoplatform.commons.serialization.F;
import org.exoplatform.commons.serialization.G;
import org.exoplatform.commons.serialization.SerializationContext;
import org.exoplatform.commons.serialization.model.TypeDomain;
import org.exoplatform.component.test.AbstractGateInTest;

public class TestSerialization
extends AbstractGateInTest {
    public void testState() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(A.class);
        A a = new A();
        a.a = "foo";
        a.b = 2;
        a.c = true;
        SerializationContext context = new SerializationContext(domain);
        a = (A)context.clone((Object)a);
        TestSerialization.assertEquals((String)"foo", (String)a.a);
        TestSerialization.assertEquals((int)2, (int)a.b);
        TestSerialization.assertEquals((boolean)true, (boolean)a.c);
    }

    public void testMultipleReference1() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(B.class);
        B b = new B();
        b.ref = new B(b);
        SerializationContext context = new SerializationContext(domain);
        b = (B)context.clone((Object)b);
        TestSerialization.assertNotNull((Object)b.ref);
        TestSerialization.assertSame((Object)b, (Object)b.ref.ref);
    }

    public void testStaticField() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(D.class);
        D d = new D();
        d.b = "bar";
        SerializationContext context = new SerializationContext(domain);
        byte[] bytes = context.write((Object)d);
        D.a = "foo";
        d = (D)context.read(bytes);
        TestSerialization.assertEquals((String)"foo", (String)D.a);
        TestSerialization.assertEquals((String)"bar", (String)d.b);
    }

    public void testMultipleReference2() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(E2.class);
        E2 e = new E2();
        e.left = new E2();
        ((E2)e.left).left = new E1();
        ((E2)e.left).right = new E1();
        e.right = new E2();
        ((E2)e.right).left = ((E2)e.left).left;
        ((E2)e.right).right = ((E2)e.left).right;
        SerializationContext context = new SerializationContext(domain);
        e = (E2)context.clone((Object)e);
        TestSerialization.assertSame((Object)((E2)e.left).left, (Object)((E2)e.right).left);
        TestSerialization.assertSame((Object)((E2)e.left).right, (Object)((E2)e.right).right);
    }

    public void testListOfReplicatable() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(F.class);
        F f1 = new F();
        F f2 = new F();
        f1.children.add(f2);
        f2.parent = f1;
        SerializationContext context = new SerializationContext(domain);
        f1 = (F)context.clone((Object)f1);
        TestSerialization.assertNotNull(f1.children);
        TestSerialization.assertNull((Object)f1.parent);
        TestSerialization.assertEquals((int)1, (int)f1.children.size());
        TestSerialization.assertNotNull((Object)f1.children.get(0));
        TestSerialization.assertSame((Object)f1, (Object)f1.children.get((int)0).parent);
    }

    public void testNotSerializable() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(ByteArrayInputStream.class);
        SerializationContext context = new SerializationContext(domain);
        try {
            context.write((Object)new ByteArrayInputStream(new byte[0]));
            TestSerialization.fail();
        }
        catch (NotSerializableException notSerializableException) {
            // empty catch block
        }
    }

    public void testTransientField() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(G.class);
        SerializationContext context = new SerializationContext(domain);
        G g = new G();
        g.a = "foo";
        g.b = new Thread();
        g = (G)context.clone((Object)g);
        TestSerialization.assertEquals((String)"foo", (String)g.a);
        TestSerialization.assertEquals(null, (Object)g.b);
    }
}

