/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.Serializable;
import org.exoplatform.commons.serialization.MarshalledObject;
import org.exoplatform.component.test.AbstractGateInTest;

public class TestMarshalledObject
extends AbstractGateInTest {
    public void testSerialization() {
        String from = "foo";
        MarshalledObject marshalled = MarshalledObject.marshall((Serializable)((Object)from));
        String to = (String)((Object)marshalled.unmarshall());
        TestMarshalledObject.assertEquals((String)to, (String)from);
    }

    public void testNPE() {
        try {
            MarshalledObject.marshall(null);
            TestMarshalledObject.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHashCode() {
        MarshalledObject marshalled1 = MarshalledObject.marshall((Serializable)((Object)"foo"));
        TestMarshalledObject.assertEquals((int)marshalled1.hashCode(), (int)marshalled1.hashCode());
        MarshalledObject marshalled2 = MarshalledObject.marshall((Serializable)((Object)"foo"));
        TestMarshalledObject.assertEquals((int)marshalled1.hashCode(), (int)marshalled2.hashCode());
        TestMarshalledObject.assertEquals((int)marshalled2.hashCode(), (int)marshalled1.hashCode());
        MarshalledObject marshalled3 = MarshalledObject.marshall((Serializable)((Object)"bar"));
        TestMarshalledObject.assertNotSame((Object)marshalled1.hashCode(), (Object)marshalled3.hashCode());
        TestMarshalledObject.assertNotSame((Object)marshalled3.hashCode(), (Object)marshalled1.hashCode());
    }

    public void testEquals() {
        MarshalledObject marshalled1 = MarshalledObject.marshall((Serializable)((Object)"foo"));
        TestMarshalledObject.assertTrue((boolean)marshalled1.equals((Object)marshalled1));
        MarshalledObject marshalled2 = MarshalledObject.marshall((Serializable)((Object)"foo"));
        TestMarshalledObject.assertTrue((boolean)marshalled1.equals((Object)marshalled2));
        TestMarshalledObject.assertTrue((boolean)marshalled2.equals((Object)marshalled1));
        MarshalledObject marshalled3 = MarshalledObject.marshall((Serializable)((Object)"bar"));
        TestMarshalledObject.assertFalse((boolean)marshalled1.equals((Object)marshalled3));
        TestMarshalledObject.assertFalse((boolean)marshalled3.equals((Object)marshalled1));
    }
}

