/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.Queues;

public class TestQueues
extends TestCase {
    public void testLIFO() {
        Queue lifo = Queues.lifo();
        TestQueues.assertEquals((int)0, (int)lifo.size());
        TestQueues.assertTrue((boolean)lifo.add("a"));
        TestQueues.assertEquals((int)1, (int)lifo.size());
        TestQueues.assertTrue((boolean)lifo.add("b"));
        TestQueues.assertEquals((int)2, (int)lifo.size());
        TestQueues.assertTrue((boolean)lifo.add("c"));
        TestQueues.assertEquals((int)3, (int)lifo.size());
        Iterator it = lifo.iterator();
        TestQueues.assertEquals((String)"c", (String)((String)it.next()));
        TestQueues.assertEquals((String)"b", (String)((String)it.next()));
        TestQueues.assertEquals((String)"a", (String)((String)it.next()));
        TestQueues.assertFalse((boolean)it.hasNext());
        TestQueues.assertEquals((String)"c", (String)((String)lifo.peek()));
        TestQueues.assertEquals((int)3, (int)lifo.size());
        TestQueues.assertEquals((String)"c", (String)((String)lifo.poll()));
        TestQueues.assertEquals((int)2, (int)lifo.size());
        TestQueues.assertEquals((String)"b", (String)((String)lifo.poll()));
        TestQueues.assertEquals((int)1, (int)lifo.size());
        TestQueues.assertEquals((String)"a", (String)((String)lifo.poll()));
        TestQueues.assertEquals((int)0, (int)lifo.size());
        TestQueues.assertEquals(null, (String)((String)lifo.poll()));
        TestQueues.assertEquals(null, (String)((String)lifo.peek()));
        TestQueues.assertEquals((int)0, (int)lifo.size());
        TestQueues.assertEquals(null, (String)((String)lifo.poll()));
        TestQueues.assertEquals(null, (String)((String)lifo.peek()));
        TestQueues.assertEquals((int)0, (int)lifo.size());
    }

    public void testLIFOResize() {
        Queue lifo = Queues.lifo((int)0);
        TestQueues.assertEquals((int)0, (int)lifo.size());
        lifo.add("a");
        TestQueues.assertEquals((int)1, (int)lifo.size());
        TestQueues.assertEquals((String)"a", (String)((String)lifo.peek()));
        TestQueues.assertEquals((String)"a", (String)((String)lifo.poll()));
        TestQueues.assertEquals((int)0, (int)lifo.size());
    }

    public void testEmpty() {
        Queue lifo = Queues.empty();
        TestQueues.assertFalse((boolean)lifo.offer(""));
        try {
            lifo.add("");
            TestQueues.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TestQueues.assertEquals((int)0, (int)lifo.size());
        TestQueues.assertNull(lifo.peek());
        TestQueues.assertNull(lifo.poll());
        try {
            lifo.element();
            TestQueues.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

