/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa.settings.impl;

import org.exoplatform.commons.api.event.EventManager;
import org.exoplatform.commons.api.settings.SettingListener;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.EventType;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.api.settings.data.SettingContext;
import org.exoplatform.commons.api.settings.data.SettingData;
import org.exoplatform.commons.api.settings.data.SettingKey;
import org.exoplatform.commons.api.settings.data.SettingScope;
import org.exoplatform.jpa.CommonsDAOJPAImplTest;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.settings.jpa.JPASettingServiceImpl;

public class JPASettingServiceImplEventTest
extends CommonsDAOJPAImplTest {
    protected static JPASettingServiceImpl settingService;
    private EventManager<SettingService, SettingData> eventManager;

    @Override
    public void setUp() {
        super.setUp();
        settingService = this.getService(JPASettingServiceImpl.class);
        ConversationState c = new ConversationState(new Identity("root"));
        ConversationState.setCurrent((ConversationState)c);
        this.eventManager = this.getService(EventManager.class);
    }

    public void testEventForSetMethod() {
        ListenerImpl listener = new ListenerImpl(this);
        listener.setName(EventType.SETTING_SET.toString());
        this.eventManager.addEventListener((Listener)listener);
        Scope spaceScope = Scope.SPACE.id("space");
        settingService.set(Context.USER, spaceScope, "xyz", SettingValue.create((String)"b"));
        JPASettingServiceImplEventTest.assertEquals((Object)listener.settingContext, (Object)new SettingKey(Context.USER, spaceScope, "xyz"));
        JPASettingServiceImplEventTest.assertEquals((Object)listener.settingValue.getValue(), (Object)"b");
        JPASettingServiceImplEventTest.assertEquals((Object)listener.eventype, (Object)EventType.SETTING_SET);
    }

    public void testEventForKeyRemove() {
        ListenerImpl listener = new ListenerImpl(this);
        listener.setName(EventType.SETTING_REMOVE_KEY.toString());
        this.eventManager.addEventListener((Listener)listener);
        Scope spaceScope = Scope.SPACE.id("space");
        settingService.set(Context.USER, spaceScope, "xyz", SettingValue.create((String)"b"));
        settingService.remove(Context.USER, spaceScope, "xyz");
        JPASettingServiceImplEventTest.assertEquals((Object)new SettingKey(Context.USER, spaceScope, "xyz"), (Object)listener.settingContext);
        JPASettingServiceImplEventTest.assertEquals((Object)EventType.SETTING_REMOVE_KEY, (Object)listener.eventype);
    }

    public void testEventForScopeRemove() {
        settingService.set(Context.GLOBAL, Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y1"));
        settingService.set(Context.GLOBAL, Scope.PAGE.id("name1"), "x2", SettingValue.create((String)"y2"));
        ListenerImpl listener = new ListenerImpl(this);
        listener.setName(EventType.SETTING_REMOVE_SCOPE.toString());
        this.eventManager.addEventListener((Listener)listener);
        settingService.remove(Context.GLOBAL, Scope.PAGE.id("name1"));
        JPASettingServiceImplEventTest.assertEquals((Object)listener.settingContext, (Object)new SettingScope(Context.GLOBAL, Scope.PAGE.id("name1")));
        JPASettingServiceImplEventTest.assertEquals((Object)listener.eventype, (Object)EventType.SETTING_REMOVE_SCOPE);
    }

    public void testEventForUserRemove() {
        ListenerImpl listener = new ListenerImpl(this);
        listener.setName(EventType.SETTING_REMOVE_CONTEXT.toString());
        this.eventManager.addEventListener((Listener)listener);
        settingService.set(Context.USER, Scope.PORTAL.id("name1"), "x1", SettingValue.create((String)"y1"));
        settingService.set(Context.USER, Scope.PORTAL.id("name2"), "x2", SettingValue.create((String)"y2"));
        settingService.set(Context.USER, Scope.PAGE.id("name3"), "x3", SettingValue.create((String)"y3"));
        settingService.remove(Context.USER);
        JPASettingServiceImplEventTest.assertEquals((Object)listener.settingContext, (Object)new SettingContext(Context.USER));
        JPASettingServiceImplEventTest.assertEquals((Object)listener.eventype, (Object)EventType.SETTING_REMOVE_CONTEXT);
    }

    class ListenerImpl
    extends SettingListener {
        private SettingContext settingContext = null;
        private SettingValue<?> settingValue = null;
        EventType eventype;

        ListenerImpl(JPASettingServiceImplEventTest this$0) {
        }

        public void onSet(Event<SettingService, SettingData> event) {
            this.clearData();
            SettingData data = (SettingData)event.getData();
            if (data.getSettingContext() instanceof SettingKey) {
                this.settingContext = (SettingKey)data.getSettingContext();
                this.settingValue = data.getSettingValue();
            }
            this.eventype = ((SettingData)event.getData()).getEventType();
        }

        public void onRemoveKey(Event<SettingService, SettingData> event) {
            this.clearData();
            SettingData data = (SettingData)event.getData();
            this.settingContext = (SettingKey)data.getSettingContext();
            this.settingValue = data.getSettingValue();
            this.eventype = ((SettingData)event.getData()).getEventType();
        }

        public void onRemoveScope(Event<SettingService, SettingData> event) {
            this.clearData();
            SettingData data = (SettingData)event.getData();
            this.settingContext = (SettingScope)data.getSettingContext();
            this.eventype = ((SettingData)event.getData()).getEventType();
        }

        public void onRemoveContext(Event<SettingService, SettingData> event) {
            this.clearData();
            SettingData data = (SettingData)event.getData();
            this.settingContext = data.getSettingContext();
            this.eventype = ((SettingData)event.getData()).getEventType();
        }

        private void clearData() {
            this.settingContext = null;
            this.settingValue = null;
            this.eventype = null;
        }
    }
}

