/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.PersistenceException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.EventType;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.api.settings.data.SettingContext;
import org.exoplatform.commons.api.settings.data.SettingData;
import org.exoplatform.commons.api.settings.data.SettingKey;
import org.exoplatform.commons.api.settings.data.SettingScope;
import org.exoplatform.commons.event.impl.EventManagerImpl;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.settings.jpa.EntityConverter;
import org.exoplatform.settings.jpa.SettingContextDAO;
import org.exoplatform.settings.jpa.SettingScopeDAO;
import org.exoplatform.settings.jpa.SettingsDAO;
import org.exoplatform.settings.jpa.entity.ContextEntity;
import org.exoplatform.settings.jpa.entity.ScopeEntity;
import org.exoplatform.settings.jpa.entity.SettingsEntity;

public class JPASettingServiceImpl
implements SettingService {
    private static final Log LOG;
    private SettingsDAO settingsDAO;
    private SettingContextDAO settingContextDAO;
    private SettingScopeDAO settingScopeDAO;
    private final EventManagerImpl<JPASettingServiceImpl, SettingData> eventManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public JPASettingServiceImpl(SettingsDAO settingsDAO, SettingContextDAO settingContextDAO, SettingScopeDAO settingScopeDAO, EventManagerImpl<JPASettingServiceImpl, SettingData> eventManager, DataInitializer dataInitializer) {
        this.settingsDAO = settingsDAO;
        this.settingContextDAO = settingContextDAO;
        this.settingScopeDAO = settingScopeDAO;
        this.eventManager = eventManager;
    }

    @ExoTransactional
    public void set(Context context, Scope scope, String key, SettingValue<?> value) {
        Context context2 = context;
        Scope scope2 = scope;
        String string = key;
        SettingValue<?> settingValue = value;
        Object[] objectArray = new Object[]{context2, scope2, string, settingValue};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        JPASettingServiceImpl.set_aroundBody1$advice(this, context2, scope2, string, settingValue, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public void remove(Context context, Scope scope, String key) {
        Context context2 = context;
        Scope scope2 = scope;
        String string = key;
        Object[] objectArray = new Object[]{context2, scope2, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        JPASettingServiceImpl.remove_aroundBody3$advice(this, context2, scope2, string, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public void remove(Context context, Scope scope) {
        Context context2 = context;
        Scope scope2 = scope;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)context2, (Object)scope2);
        JPASettingServiceImpl.remove_aroundBody5$advice(this, context2, scope2, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public void remove(Context context) {
        Context context2 = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)context2);
        JPASettingServiceImpl.remove_aroundBody7$advice(this, context2, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public SettingValue<?> get(Context context, Scope scope, String key) {
        Context context2 = context;
        Scope scope2 = scope;
        String string = key;
        Object[] objectArray = new Object[]{context2, scope2, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        return (SettingValue)JPASettingServiceImpl.get_aroundBody9$advice(this, context2, scope2, string, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public void save(Context context) {
        Context context2 = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)context2);
        JPASettingServiceImpl.save_aroundBody11$advice(this, context2, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public Map<Scope, Map<String, SettingValue<String>>> getSettingsByContext(Context context) {
        Context context2 = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)context2);
        return (Map)JPASettingServiceImpl.getSettingsByContext_aroundBody13$advice(this, context2, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public long countContextsByType(String contextType) {
        this.validateArgumentNullability(contextType, "context type is null");
        return this.settingContextDAO.countContextsByType(contextType);
    }

    public List<String> getContextNamesByType(String contextType, int offset, int limit) {
        this.validateArgumentNullability(contextType, "context type is null");
        return this.settingContextDAO.getContextNamesByType(contextType, offset, limit);
    }

    @ExoTransactional
    public Set<String> getEmptyContextsByTypeAndScopeAndSettingName(String contextType, String scopeType, String scopeName, String settingName, int offset, int limit) {
        String string = contextType;
        String string2 = scopeType;
        String string3 = scopeName;
        String string4 = settingName;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{string, string2, string3, string4, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        return (Set)JPASettingServiceImpl.getEmptyContextsByTypeAndScopeAndSettingName_aroundBody15$advice(this, string, string2, string3, string4, n, n2, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public List<Context> getContextsByTypeAndScopeAndSettingName(String contextType, String scopeType, String scopeName, String settingName, int offset, int limit) {
        String string = contextType;
        String string2 = scopeType;
        String string3 = scopeName;
        String string4 = settingName;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{string, string2, string3, string4, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        return (List)JPASettingServiceImpl.getContextsByTypeAndScopeAndSettingName_aroundBody17$advice(this, string, string2, string3, string4, n, n2, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public long countSettingsByNameAndValueAndScope(Scope scope, String key, String value) {
        Scope scope2 = scope;
        String string = key;
        String string2 = value;
        Object[] objectArray = new Object[]{scope2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        return Conversions.longValue((Object)JPASettingServiceImpl.countSettingsByNameAndValueAndScope_aroundBody19$advice(this, scope2, string, string2, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    private void validateScopeArgument(Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        this.validateArgumentNullability(scope.getName(), "scope name is null");
    }

    private void validateContextArgument(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.validateArgumentNullability(context.getId(), "context id is null");
        this.validateArgumentNullability(context.getName(), "context name is null");
    }

    private void validateArgumentNullability(String arg, String message) {
        if (StringUtils.isBlank((CharSequence)arg)) {
            throw new IllegalArgumentException(message);
        }
    }

    private void validateArgumentNullability(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public Map<String, SettingValue> getSettingsByContextAndScope(String contextType, String contextName, String scopeType, String scopeName) {
        HashMap<String, SettingValue> settingsKeyValue = new HashMap<String, SettingValue>();
        List<SettingsEntity> settingsList = this.settingsDAO.getSettingsByContextAndScope(contextType, contextName, scopeType, scopeName);
        settingsList.stream().forEach(setting -> settingsKeyValue.put(setting.getName(), SettingValue.create((String)setting.getValue())));
        return settingsKeyValue;
    }

    static {
        JPASettingServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(JPASettingServiceImpl.class);
    }

    private static final /* synthetic */ void set_aroundBody0(JPASettingServiceImpl ajc$this, Context context, Scope scope, String key, SettingValue value, JoinPoint joinPoint) {
        ajc$this.validateContextArgument(context);
        ajc$this.validateScopeArgument(scope);
        ajc$this.validateArgumentNullability(key, "setting name is null");
        ajc$this.validateArgumentNullability(value, "setting value is null");
        try {
            ScopeEntity scopeEntity;
            if (context == null) {
                LOG.warn("Context is null, can't save setting key={}, value={}", new Object[]{key, value.getValue()});
                return;
            }
            if (scope == null) {
                scope = Scope.GLOBAL.id(null);
            }
            LOG.debug("=== setting save, contextType={}, contextName={}, scopeType={} and scopeName={} and key={} and value={}", new Object[]{context.getName(), context.getId(), scope.getName(), scope.getId(), key, value.getValue()});
            ContextEntity contextEntity = ajc$this.settingContextDAO.getContextByTypeAndName(context.getName(), context.getId());
            boolean contextAndScopeFound = true;
            if (contextEntity == null) {
                contextAndScopeFound = false;
                contextEntity = (ContextEntity)ajc$this.settingContextDAO.create(EntityConverter.convertContextToContextEntity(context));
            }
            if ((scopeEntity = ajc$this.settingScopeDAO.getScopeByTypeAndName(scope.getName(), scope.getId())) == null) {
                contextAndScopeFound = false;
                scopeEntity = EntityConverter.convertScopeToScopeEntity(scope);
                scopeEntity = (ScopeEntity)ajc$this.settingScopeDAO.create(scopeEntity);
            }
            SettingsEntity settingsEntity = null;
            if (contextAndScopeFound) {
                settingsEntity = ajc$this.settingsDAO.getSettingByContextAndScopeAndKey(context.getName(), context.getId(), scope.getName(), scope.getId(), key);
            }
            if (settingsEntity == null) {
                ajc$this.settingsDAO.create(new SettingsEntity().setScope(scopeEntity).setContext(contextEntity).setName(key).setValue(value.getValue().toString()));
            } else {
                settingsEntity.setValue(value.getValue().toString());
                ajc$this.settingsDAO.update(settingsEntity);
            }
            SettingData data = new SettingData(EventType.SETTING_SET, (SettingContext)new SettingKey(context, scope, key), value);
            ajc$this.eventManager.broadcastEvent((Event<JPASettingServiceImpl, SettingData>)new Event(data.getEventType().toString(), (Object)ajc$this, (Object)data));
        }
        catch (Exception e) {
            LOG.error((Object)("An error occurred while saving setting: contextType=" + context.getName() + ", contextName=" + context.getId() + ", scopeType=" + scope.getName() + " and scopeName=" + scope.getId() + " and key=" + key + " and value=" + String.valueOf(value.getValue())), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final /* synthetic */ Object set_aroundBody1$advice(JPASettingServiceImpl ajc$this, Context context, Scope scope, String key, SettingValue value, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$getService();
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", (Throwable)e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", (Throwable)e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPASettingServiceImpl.set_aroundBody0(ajc$this, context, scope, key, value, (JoinPoint)proceedingJoinPoint);
            Object var13_14 = null;
            return var13_14;
        }
        finally {
            block27: {
                try {
                    if (!begunTx || !tx.isActive()) break block27;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static final /* synthetic */ void remove_aroundBody2(JPASettingServiceImpl ajc$this, Context context, Scope scope, String key, JoinPoint joinPoint) {
        ajc$this.validateContextArgument(context);
        ajc$this.validateScopeArgument(scope);
        ajc$this.validateArgumentNullability(key, "setting name is null");
        SettingsEntity setting = ajc$this.settingsDAO.getSettingByContextAndScopeAndKey(context.getName(), context.getId(), scope.getName(), scope.getId(), key);
        if (setting != null) {
            ajc$this.settingsDAO.delete(setting);
            SettingData data = new SettingData(EventType.SETTING_REMOVE_KEY, (SettingContext)new SettingKey(context, scope, key));
            ajc$this.eventManager.broadcastEvent((Event<JPASettingServiceImpl, SettingData>)new Event(data.getEventType().toString(), (Object)ajc$this, (Object)data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final /* synthetic */ Object remove_aroundBody3$advice(JPASettingServiceImpl ajc$this, Context context, Scope scope, String key, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$getService();
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", (Throwable)e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", (Throwable)e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPASettingServiceImpl.remove_aroundBody2(ajc$this, context, scope, key, (JoinPoint)proceedingJoinPoint);
            Object var12_13 = null;
            return var12_13;
        }
        finally {
            block27: {
                try {
                    if (!begunTx || !tx.isActive()) break block27;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static final /* synthetic */ void remove_aroundBody4(JPASettingServiceImpl ajc$this, Context context, Scope scope, JoinPoint joinPoint) {
        ajc$this.validateContextArgument(context);
        ajc$this.validateScopeArgument(scope);
        List<SettingsEntity> settings = ajc$this.settingsDAO.getSettingsByContextAndScope(context.getName(), context.getId(), scope.getName(), scope.getId());
        ajc$this.settingsDAO.deleteAll(settings);
        SettingData data = new SettingData(EventType.SETTING_REMOVE_SCOPE, (SettingContext)new SettingScope(context, scope));
        ajc$this.eventManager.broadcastEvent((Event<JPASettingServiceImpl, SettingData>)new Event(data.getEventType().toString(), (Object)ajc$this, (Object)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final /* synthetic */ Object remove_aroundBody5$advice(JPASettingServiceImpl ajc$this, Context context, Scope scope, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$getService();
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", (Throwable)e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", (Throwable)e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPASettingServiceImpl.remove_aroundBody4(ajc$this, context, scope, (JoinPoint)proceedingJoinPoint);
            Object var11_12 = null;
            return var11_12;
        }
        finally {
            block27: {
                try {
                    if (!begunTx || !tx.isActive()) break block27;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static final /* synthetic */ void remove_aroundBody6(JPASettingServiceImpl ajc$this, Context context, JoinPoint joinPoint) {
        ajc$this.validateContextArgument(context);
        List<SettingsEntity> settings = ajc$this.settingsDAO.getSettingsByContextTypeAndName(context.getName(), context.getId());
        ajc$this.settingsDAO.deleteAll(settings);
        SettingData data = new SettingData(EventType.SETTING_REMOVE_CONTEXT, new SettingContext(context));
        ajc$this.eventManager.broadcastEvent((Event<JPASettingServiceImpl, SettingData>)new Event(data.getEventType().toString(), (Object)ajc$this, (Object)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final /* synthetic */ Object remove_aroundBody7$advice(JPASettingServiceImpl ajc$this, Context context, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$getService();
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", (Throwable)e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", (Throwable)e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPASettingServiceImpl.remove_aroundBody6(ajc$this, context, (JoinPoint)proceedingJoinPoint);
            Object var10_11 = null;
            return var10_11;
        }
        finally {
            block27: {
                try {
                    if (!begunTx || !tx.isActive()) break block27;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static final /* synthetic */ SettingValue get_aroundBody8(JPASettingServiceImpl ajc$this, Context context, Scope scope, String key, JoinPoint joinPoint) {
        ajc$this.validateContextArgument(context);
        ajc$this.validateScopeArgument(scope);
        ajc$this.validateArgumentNullability(key, "setting name is null");
        SettingsEntity setting = ajc$this.settingsDAO.getSettingByContextAndScopeAndKey(context.getName(), context.getId(), scope.getName(), scope.getId(), key);
        if (setting == null) {
            return null;
        }
        return SettingValue.create((String)setting.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final /* synthetic */ Object get_aroundBody9$advice(JPASettingServiceImpl ajc$this, Context context, Scope scope, String key, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$getService();
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", (Throwable)e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", (Throwable)e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            SettingValue settingValue = JPASettingServiceImpl.get_aroundBody8(ajc$this, context, scope, key, (JoinPoint)proceedingJoinPoint);
            return settingValue;
        }
        finally {
            block27: {
                try {
                    if (!begunTx || !tx.isActive()) break block27;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static final /* synthetic */ void save_aroundBody10(JPASettingServiceImpl ajc$this, Context context, JoinPoint joinPoint) {
        ajc$this.validateContextArgument(context);
        ContextEntity contextEntity = ajc$this.settingContextDAO.getContextByTypeAndName(context.getName(), context.getId());
        if (contextEntity == null) {
            contextEntity = new ContextEntity();
            contextEntity.setType(context.getName());
            contextEntity.setName(context.getId());
            ajc$this.settingContextDAO.create(contextEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final /* synthetic */ Object save_aroundBody11$advice(JPASettingServiceImpl ajc$this, Context context, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$getService();
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", (Throwable)e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", (Throwable)e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPASettingServiceImpl.save_aroundBody10(ajc$this, context, (JoinPoint)proceedingJoinPoint);
            Object var10_11 = null;
            return var10_11;
        }
        finally {
            block27: {
                try {
                    if (!begunTx || !tx.isActive()) break block27;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static final /* synthetic */ Map getSettingsByContext_aroundBody12(JPASettingServiceImpl ajc$this, Context context, JoinPoint joinPoint) {
        ajc$this.validateContextArgument(context);
        List<SettingsEntity> settings = ajc$this.settingsDAO.getSettingsByContextTypeAndName(context.getName(), context.getId());
        if (settings == null || settings.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Scope, Map<String, SettingValue>> settingsByScopeByName = settings.stream().collect(Collectors.groupingBy(setting -> new Scope(setting.getScope().getType(), setting.getScope().getName()), Collectors.toMap(setting -> setting.getName(), setting -> SettingValue.create((String)setting.getValue()))));
        return settingsByScopeByName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final /* synthetic */ Object getSettingsByContext_aroundBody13$advice(JPASettingServiceImpl ajc$this, Context context, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$getService();
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", (Throwable)e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", (Throwable)e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            Map map = JPASettingServiceImpl.getSettingsByContext_aroundBody12(ajc$this, context, (JoinPoint)proceedingJoinPoint);
            return map;
        }
        finally {
            block27: {
                try {
                    if (!begunTx || !tx.isActive()) break block27;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static final /* synthetic */ Set getEmptyContextsByTypeAndScopeAndSettingName_aroundBody14(JPASettingServiceImpl ajc$this, String contextType, String scopeType, String scopeName, String settingName, int offset, int limit, JoinPoint joinPoint) {
        ajc$this.validateArgumentNullability(contextType, "context type is null");
        ajc$this.validateArgumentNullability(scopeType, "scope type is null");
        ajc$this.validateArgumentNullability(settingName, "setting name is null");
        List<ContextEntity> emptyContexts = ajc$this.settingContextDAO.getEmptyContextsByScopeAndContextType(contextType, scopeType, scopeName, settingName, offset, limit);
        return emptyContexts.stream().map(context -> context.getName()).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final /* synthetic */ Object getEmptyContextsByTypeAndScopeAndSettingName_aroundBody15$advice(JPASettingServiceImpl ajc$this, String contextType, String scopeType, String scopeName, String settingName, int offset, int limit, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$getService();
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", (Throwable)e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", (Throwable)e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            Set set = JPASettingServiceImpl.getEmptyContextsByTypeAndScopeAndSettingName_aroundBody14(ajc$this, contextType, scopeType, scopeName, settingName, offset, limit, (JoinPoint)proceedingJoinPoint);
            return set;
        }
        finally {
            block27: {
                try {
                    if (!begunTx || !tx.isActive()) break block27;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static final /* synthetic */ List getContextsByTypeAndScopeAndSettingName_aroundBody16(JPASettingServiceImpl ajc$this, String contextType, String scopeType, String scopeName, String settingName, int offset, int limit, JoinPoint joinPoint) {
        ajc$this.validateArgumentNullability(contextType, "context type is null");
        ajc$this.validateArgumentNullability(scopeType, "scope type is null");
        ajc$this.validateArgumentNullability(settingName, "setting name is null");
        List<ContextEntity> contexts = ajc$this.settingContextDAO.getContextsByTypeAndSettingNameAndScope(contextType, scopeType, scopeName, settingName, offset, limit);
        return contexts.stream().map(context -> new Context(context.getType(), context.getName())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final /* synthetic */ Object getContextsByTypeAndScopeAndSettingName_aroundBody17$advice(JPASettingServiceImpl ajc$this, String contextType, String scopeType, String scopeName, String settingName, int offset, int limit, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$getService();
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", (Throwable)e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", (Throwable)e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            List list = JPASettingServiceImpl.getContextsByTypeAndScopeAndSettingName_aroundBody16(ajc$this, contextType, scopeType, scopeName, settingName, offset, limit, (JoinPoint)proceedingJoinPoint);
            return list;
        }
        finally {
            block27: {
                try {
                    if (!begunTx || !tx.isActive()) break block27;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static final /* synthetic */ long countSettingsByNameAndValueAndScope_aroundBody18(JPASettingServiceImpl ajc$this, Scope scope, String key, String value, JoinPoint joinPoint) {
        ajc$this.validateScopeArgument(scope);
        ajc$this.validateArgumentNullability(key, "setting name is null");
        ajc$this.validateArgumentNullability(value, "setting value is null");
        return ajc$this.settingsDAO.countSettingsByNameAndValueAndScope(scope.getName(), scope.getId(), key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final /* synthetic */ Object countSettingsByNameAndValueAndScope_aroundBody19$advice(JPASettingServiceImpl ajc$this, Scope scope, String key, String value, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$getService();
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", (Throwable)e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", (Throwable)e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            Object object = Conversions.longObject((long)JPASettingServiceImpl.countSettingsByNameAndValueAndScope_aroundBody18(ajc$this, scope, key, value, (JoinPoint)proceedingJoinPoint));
            return object;
        }
        finally {
            block27: {
                try {
                    if (!begunTx || !tx.isActive()) break block27;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JPASettingServiceImpl.java", JPASettingServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "set", "org.exoplatform.settings.jpa.JPASettingServiceImpl", "org.exoplatform.commons.api.settings.data.Context:org.exoplatform.commons.api.settings.data.Scope:java.lang.String:org.exoplatform.commons.api.settings.SettingValue", "context:scope:key:value", "", "void"), 79);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.settings.jpa.JPASettingServiceImpl", "org.exoplatform.commons.api.settings.data.Context:org.exoplatform.commons.api.settings.data.Scope:java.lang.String", "context:scope:key", "", "void"), 148);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.settings.jpa.JPASettingServiceImpl", "org.exoplatform.commons.api.settings.data.Context:org.exoplatform.commons.api.settings.data.Scope", "context:scope", "", "void"), 170);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.settings.jpa.JPASettingServiceImpl", "org.exoplatform.commons.api.settings.data.Context", "context", "", "void"), 188);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "org.exoplatform.settings.jpa.JPASettingServiceImpl", "org.exoplatform.commons.api.settings.data.Context:org.exoplatform.commons.api.settings.data.Scope:java.lang.String", "context:scope:key", "", "org.exoplatform.commons.api.settings.SettingValue"), 202);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "org.exoplatform.settings.jpa.JPASettingServiceImpl", "org.exoplatform.commons.api.settings.data.Context", "context", "", "void"), 224);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSettingsByContext", "org.exoplatform.settings.jpa.JPASettingServiceImpl", "org.exoplatform.commons.api.settings.data.Context", "context", "", "java.util.Map"), 241);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEmptyContextsByTypeAndScopeAndSettingName", "org.exoplatform.settings.jpa.JPASettingServiceImpl", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:int:int", "contextType:scopeType:scopeName:settingName:offset:limit", "", "java.util.Set"), 288);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getContextsByTypeAndScopeAndSettingName", "org.exoplatform.settings.jpa.JPASettingServiceImpl", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:int:int", "contextType:scopeType:scopeName:settingName:offset:limit", "", "java.util.List"), 312);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "countSettingsByNameAndValueAndScope", "org.exoplatform.settings.jpa.JPASettingServiceImpl", "org.exoplatform.commons.api.settings.data.Scope:java.lang.String:java.lang.String", "scope:key:value", "", "long"), 327);
    }
}

