/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.xml;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.exoplatform.commons.xml.DOMSerializer;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class TestDOMSerializer
extends TestCase {
    protected void setUp() throws Exception {
    }

    public void testScriptNoAttributes() throws Exception {
        this.assertSerialization("<script></script>", "<script/>");
    }

    public void testScriptWithAttribute() throws Exception {
        this.assertSerialization("<script type=\"text/javascript\"></script>", "<script type='text/javascript'/>");
    }

    public void testMetaNoAttributes() throws Exception {
        this.assertSerialization("<meta/>", "<meta/>");
    }

    public void testMetaWithAttribute() throws Exception {
        this.assertSerialization("<meta http-equiv=\"Content-Type\"/>", "<meta http-equiv='Content-Type'></meta>");
    }

    public void testOrdinaryTextElement() throws Exception {
        this.assertSerialization("<div>Blah Blah</div>", "<div>Blah Blah</div>");
    }

    public void testCDATaElement() throws Exception {
        this.assertSerialization("<div><![CDATA[Test Content]]></div>", "<div><![CDATA[Test Content]]></div>");
    }

    private void assertSerialization(String expectedMarkup, String markup) throws Exception {
        Element elt = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(markup))).getDocumentElement();
        StringWriter writer = new StringWriter();
        DOMSerializer.serialize((Element)elt, (Writer)writer);
        TestDOMSerializer.assertEquals((String)expectedMarkup, (String)writer.toString());
    }
}

