/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.upload;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.upload.UploadService;
import org.junit.Test;
import org.mockito.Mockito;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/services/upload-service.xml")})
public class TestUploadService
extends AbstractKernelTest {
    private static final String tmpDir = System.getProperty("java.io.tmpdir");
    UploadService uploadService;

    protected void beforeRunBare() {
        super.beforeRunBare();
        this.uploadService = (UploadService)this.getContainer().getComponentInstanceOfType(UploadService.class);
    }

    @Test
    public void testCorrectFileName() {
        String fileName = "test_abcdef0123456789.ext";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test_abcdef0123456789.ext", (String)fileName);
        this.assertFileCreation(fileName);
        fileName = "test~`!@#$%^&*()-=+_.ext";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test~`!@#$%^&_()-=+_.ext", (String)fileName);
        this.assertFileCreation(fileName);
        fileName = "test[]{}\\|.ext";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test[]{}__.ext", (String)fileName);
        this.assertFileCreation(fileName);
        fileName = "test;:\"'.ext";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test;__'.ext", (String)fileName);
        this.assertFileCreation(fileName);
        fileName = "test_t\u00ean ti\u1ebfng vi\u1ec7t.m\u1edf r\u1ed9ng";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test_t\u00ean ti\u1ebfng vi\u1ec7t.m\u1edf r\u1ed9ng", (String)fileName);
        this.assertFileCreation(fileName);
        fileName = "test_\u8d8a\u5357\u4eba\u7684\u540d\u5b57\u3002\u6269\u5c55";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test_\u8d8a\u5357\u4eba\u7684\u540d\u5b57\u3002\u6269\u5c55", (String)fileName);
        this.assertFileCreation(fileName);
        fileName = "test_\u0412'\u0454\u0442\u043d\u0430\u043c\u0441\u044c\u043a\u0456 \u0456\u043c\u0435\u043d\u0430. \u0440\u043e\u0437\u0448\u0438\u0440\u0435\u043d\u043d\u044f";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test_\u0412'\u0454\u0442\u043d\u0430\u043c\u0441\u044c\u043a\u0456 \u0456\u043c\u0435\u043d\u0430. \u0440\u043e\u0437\u0448\u0438\u0440\u0435\u043d\u043d\u044f", (String)fileName);
        this.assertFileCreation(fileName);
        fileName = "test_\ubca0\ud2b8\ub0a8\uc5b4 \uc774\ub984. \ud655\uc7a5";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test_\ubca0\ud2b8\ub0a8\uc5b4 \uc774\ub984. \ud655\uc7a5", (String)fileName);
        this.assertFileCreation(fileName);
        fileName = "test_\u0935\u093f\u092f\u0924\u0928\u093e\u092e\u0940 \u0928\u093e\u092e\u094b\u0902. \u0935\u093f\u0938\u094d\u0924\u093e\u0930";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test_\u0935\u093f\u092f\u0924\u0928\u093e\u092e\u0940 \u0928\u093e\u092e\u094b\u0902. \u0935\u093f\u0938\u094d\u0924\u093e\u0930", (String)fileName);
        this.assertFileCreation(fileName);
        fileName = "test_\u30d9\u30c8\u30ca\u30e0\u8a9e\u540d\u3002\u62e1\u5927";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test_\u30d9\u30c8\u30ca\u30e0\u8a9e\u540d\u3002\u62e1\u5927", (String)fileName);
        this.assertFileCreation(fileName);
        fileName = "test_\u0a35\u0a40\u0a05\u0a24\u0a28\u0a3e\u0a2e\u0a40 \u0a28\u0a3e\u0a2e. \u0a35\u0a3f\u0a38\u0a24\u0a3e\u0a30";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test_\u0a35\u0a40\u0a05\u0a24\u0a28\u0a3e\u0a2e\u0a40 \u0a28\u0a3e\u0a2e. \u0a35\u0a3f\u0a38\u0a24\u0a3e\u0a30", (String)fileName);
        this.assertFileCreation(fileName);
        fileName = "test_\u0412\u044c\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0438\u0435 \u0438\u043c\u0435\u043d\u0430. \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435";
        fileName = this.uploadService.correctFileName(fileName);
        TestUploadService.assertEquals((String)"test_\u0412\u044c\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0438\u0435 \u0438\u043c\u0435\u043d\u0430. \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435", (String)fileName);
        this.assertFileCreation(fileName);
    }

    public void testShouldNotCreateUploadResourceWhenUploadIdContainsDots() {
        String notAllowedUploadId = ".webapps.ROOT.123456";
        try {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.uploadService.createUploadResource(notAllowedUploadId, request);
            TestUploadService.fail((String)("The upload resource creation must fail with the id " + notAllowedUploadId));
        }
        catch (FileUploadException e) {
            TestUploadService.assertEquals((String)("Upload id " + notAllowedUploadId + " is not valid, it cannot be null or contain '.' , '/' or '\\'"), (String)e.getMessage());
        }
    }

    public void testShouldNotCreateUploadResourceWhenUploadIdContainsSlashs() {
        String notAllowedUploadId = "/webapps/ROOT/123456";
        try {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.uploadService.createUploadResource(notAllowedUploadId, request);
            TestUploadService.fail((String)("The upload resource creation must fail with the id " + notAllowedUploadId));
        }
        catch (FileUploadException e) {
            TestUploadService.assertEquals((String)("Upload id " + notAllowedUploadId + " is not valid, it cannot be null or contain '.' , '/' or '\\'"), (String)e.getMessage());
        }
    }

    public void testShouldNotCreateUploadResourceWhenUploadIdContainsAntiSlashs() {
        String notAllowedUploadId = "\\webapps\\ROOT\\123456";
        try {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.uploadService.createUploadResource(notAllowedUploadId, request);
            TestUploadService.fail((String)("The upload resource creation must fail with the id " + notAllowedUploadId));
        }
        catch (FileUploadException e) {
            TestUploadService.assertEquals((String)("Upload id " + notAllowedUploadId + " is not valid, it cannot be null or contain '.' , '/' or '\\'"), (String)e.getMessage());
        }
    }

    private void assertFileCreation(String fileName) {
        String file = tmpDir + File.separator + fileName;
        File f = new File(file);
        f.deleteOnExit();
        try {
            f.createNewFile();
        }
        catch (IOException ex) {
            TestUploadService.fail((String)("Can not create file with name: " + fileName));
        }
    }
}

