/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.web.security;

import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.services.security.web.HttpSessionStateKey;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.jaas.JaasGrantedAuthority;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class PortalAuthenticationManager
implements AuthenticationProvider {
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        try {
            ConversationState conversationState = this.getCurrentState(request);
            Principal userPrincipal = request.getUserPrincipal();
            if (conversationState == null || !conversationState.getIdentity().isMemberOf("/platform/users") && !conversationState.getIdentity().isMemberOf("/platform/externals")) {
                return new AnonymousAuthenticationToken(IdentityConstants.ANONIM, authentication.getPrincipal(), Collections.singletonList(new JaasGrantedAuthority("guests", userPrincipal)));
            }
            List<GrantedAuthority> authorities = this.getAuthorities(conversationState.getIdentity(), userPrincipal);
            List<GrantedAuthority> extendedAuthorities = this.getExtendedAuthorities(userPrincipal);
            if (CollectionUtils.isNotEmpty(extendedAuthorities)) {
                authorities = new ArrayList<GrantedAuthority>(authorities);
                authorities.addAll(extendedAuthorities);
            }
            authentication.setAuthenticated(true);
            return new PreAuthenticatedAuthenticationToken(authentication.getPrincipal(), null, authorities);
        }
        catch (Exception e) {
            throw new AuthenticationServiceException("An unknown error is encountered while authenticating user", (Throwable)e);
        }
    }

    public boolean supports(Class<?> authentication) {
        return true;
    }

    public ConversationState getCurrentState(HttpServletRequest httpRequest) throws Exception {
        ConversationState state = ConversationState.getCurrent();
        if (state != null) {
            return state;
        }
        String userId = httpRequest.getRemoteUser();
        if (userId != null) {
            HttpSessionStateKey stateKey = new HttpSessionStateKey(httpRequest.getSession());
            state = this.getStateBySessionId(userId, (StateKey)stateKey);
            if (state == null) {
                return this.buildState(userId, (StateKey)stateKey);
            }
            return state;
        }
        return new ConversationState(new Identity(IdentityConstants.ANONIM));
    }

    protected List<GrantedAuthority> getExtendedAuthorities(Principal userPrincipal) {
        return Collections.emptyList();
    }

    private List<GrantedAuthority> getAuthorities(Identity identity, Principal principal) {
        return identity.getRoles().stream().map(role -> new JaasGrantedAuthority(role, principal)).toList();
    }

    private ConversationState buildState(String userId, StateKey stateKey) throws Exception {
        Identity identity = this.buildIdentity(userId);
        if (identity == null) {
            return null;
        }
        return this.buildState(identity, stateKey);
    }

    private ConversationState buildState(Identity identity, StateKey stateKey) {
        ConversationRegistry conversationRegistry = (ConversationRegistry)ExoContainerContext.getService(ConversationRegistry.class);
        ConversationState state = new ConversationState(identity);
        conversationRegistry.register(stateKey, state);
        return state;
    }

    private Identity buildIdentity(String userId) throws Exception {
        IdentityRegistry identityRegistry = (IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class);
        Authenticator authenticator = (Authenticator)ExoContainerContext.getService(Authenticator.class);
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            identity = authenticator.createIdentity(userId);
            identityRegistry.register(identity);
        }
        return identity;
    }

    private ConversationState getStateBySessionId(String userId, StateKey stateKey) {
        ConversationRegistry conversationRegistry = (ConversationRegistry)ExoContainerContext.getService(ConversationRegistry.class);
        ConversationState state = conversationRegistry.getState(stateKey);
        if (state != null && !userId.equals(state.getIdentity().getUserId())) {
            state = null;
            conversationRegistry.unregister(stateKey, false);
        }
        return state;
    }
}

