/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.exoplatform.commons.serialization.model.FieldModel;
import org.exoplatform.commons.serialization.model.SerializationMode;
import org.exoplatform.commons.serialization.model.TypeModel;

public final class ClassTypeModel<O>
extends TypeModel<O> {
    private final ClassTypeModel<? super O> superType;
    private final Map<String, FieldModel<O, ?>> fields;
    private final Map<String, FieldModel<O, ?>> immutableFields;
    private final SerializationMode serializationMode;

    ClassTypeModel(Class<O> type, ClassTypeModel<? super O> superType, Map<String, FieldModel<O, ?>> fields, SerializationMode serializationMode) {
        super(type, superType);
        this.superType = superType;
        this.fields = fields;
        this.immutableFields = Collections.unmodifiableMap(fields);
        this.serializationMode = serializationMode;
    }

    @Override
    public ClassTypeModel<? super O> getSuperType() {
        return this.superType;
    }

    public SerializationMode getSerializationMode() {
        return this.serializationMode;
    }

    public Collection<FieldModel<O, ?>> getFields() {
        return this.immutableFields.values();
    }

    public Map<String, FieldModel<O, ?>> getFieldMap() {
        return this.immutableFields;
    }
}

