/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.transaction;

import javax.transaction.UserTransaction;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.gatein.common.transaction.CounterListener;
import org.gatein.common.transaction.JTAUserTransactionLifecycleListener;
import org.gatein.common.transaction.JTAUserTransactionLifecycleService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.settings-configuration-local-jta.xml")})
public class JTAUserTransactionTest
extends AbstractKernelTest {
    private JTAUserTransactionLifecycleService jtaUserTransactionLifecycleService;

    protected void setUp() throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        this.jtaUserTransactionLifecycleService = (JTAUserTransactionLifecycleService)container.getComponentInstanceOfType(JTAUserTransactionLifecycleService.class);
    }

    public void testTransactionLifecycle() throws Exception {
        UserTransaction tx = this.jtaUserTransactionLifecycleService.getUserTransaction();
        JTAUserTransactionTest.assertNotNull((Object)tx);
        this.assertStatus(6);
        this.jtaUserTransactionLifecycleService.beginJTATransaction();
        this.assertStatus(0);
        this.jtaUserTransactionLifecycleService.finishJTATransaction();
        this.assertStatus(6);
        this.jtaUserTransactionLifecycleService.beginJTATransaction();
        this.assertStatus(0);
        tx.setRollbackOnly();
        this.jtaUserTransactionLifecycleService.finishJTATransaction();
        this.assertStatus(6);
    }

    public void testListener() throws Exception {
        CounterListener counterListener = new CounterListener();
        this.jtaUserTransactionLifecycleService.registerListener((JTAUserTransactionLifecycleListener)counterListener);
        UserTransaction tx = this.jtaUserTransactionLifecycleService.getUserTransaction();
        JTAUserTransactionTest.assertNotNull((Object)tx);
        JTAUserTransactionTest.assertEquals((int)counterListener.getBeforeBeginCounter(), (int)0);
        JTAUserTransactionTest.assertEquals((int)counterListener.getAfterBeginCounter(), (int)0);
        this.jtaUserTransactionLifecycleService.beginJTATransaction();
        JTAUserTransactionTest.assertEquals((int)counterListener.getBeforeBeginCounter(), (int)1);
        JTAUserTransactionTest.assertEquals((int)counterListener.getAfterBeginCounter(), (int)1);
        this.jtaUserTransactionLifecycleService.finishJTATransaction();
        this.jtaUserTransactionLifecycleService.beginJTATransaction();
        JTAUserTransactionTest.assertEquals((int)counterListener.getBeforeBeginCounter(), (int)2);
        JTAUserTransactionTest.assertEquals((int)counterListener.getAfterBeginCounter(), (int)2);
        this.jtaUserTransactionLifecycleService.finishJTATransaction();
        JTAUserTransactionTest.assertEquals((int)counterListener.getBeforeBeginCounter(), (int)2);
        JTAUserTransactionTest.assertEquals((int)counterListener.getAfterBeginCounter(), (int)2);
    }

    private void assertStatus(int expectedStatus) throws Exception {
        int status = this.jtaUserTransactionLifecycleService.getUserTransaction().getStatus();
        JTAUserTransactionTest.assertEquals((int)expectedStatus, (int)status);
    }
}

