/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.xml.stax.writer.builder;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.gatein.common.xml.stax.writer.StaxWriterImpl;
import org.gatein.common.xml.stax.writer.builder.StaxWriterBuilder;
import org.gatein.common.xml.stax.writer.formatting.XmlStreamingFormatter;
import org.staxnav.EnumElement;
import org.staxnav.Naming;
import org.staxnav.StaxNavException;

public class StaxWriterBuilderImpl
implements StaxWriterBuilder {
    private XMLStreamWriter writer;
    private Object output;
    private String outputEncoding;
    private String version;
    private String encoding;
    private XmlStreamingFormatter formatter;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, Object> supportedProperties = new HashMap<String, Object>();

    @Override
    public StaxWriterBuilder withProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.properties.put(name, value);
        return this;
    }

    @Override
    public StaxWriterBuilder withPropertyIfSupported(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.supportedProperties.put(name, value);
        return this;
    }

    @Override
    public StaxWriterBuilder withOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null");
        }
        this.output = outputStream;
        return this;
    }

    @Override
    public StaxWriterBuilder withOutputStream(OutputStream outputStream, String encoding) {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is null");
        }
        this.output = outputStream;
        this.outputEncoding = encoding;
        return this;
    }

    @Override
    public StaxWriterBuilder withWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null");
        }
        this.output = writer;
        return this;
    }

    @Override
    public StaxWriterBuilder withResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("result is null");
        }
        this.output = result;
        return this;
    }

    @Override
    public StaxWriterBuilder withXmlStreamWriter(XMLStreamWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null");
        }
        this.writer = writer;
        return this;
    }

    @Override
    public StaxWriterBuilder withEncoding(String encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is null");
        }
        this.encoding = encoding;
        return this;
    }

    @Override
    public StaxWriterBuilder withVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("version is null");
        }
        this.version = version;
        return this;
    }

    @Override
    public StaxWriterBuilder withFormatting(XmlStreamingFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    @Override
    public <E extends Enum<E>> StaxWriter<E> build(Class<E> enumeratedClass) {
        Object naming = EnumElement.class.isAssignableFrom(enumeratedClass) ? new Naming.Enumerated.Mapped(enumeratedClass, null) : new Naming.Enumerated.Simple(enumeratedClass, null);
        return this.build((Naming)naming);
    }

    @Override
    public <N> StaxWriter<N> build(Naming<N> naming) throws StaxNavException, IllegalStateException {
        if (naming == null) {
            throw new IllegalArgumentException("naming is null");
        }
        if (this.writer == null && this.output == null) {
            throw new IllegalStateException("Cannot build stax writer. Try calling withOutputStream/withWriter or pass in own XMLStreamWriter.");
        }
        if (this.writer == null) {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                factory.setProperty(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.supportedProperties.entrySet()) {
                String name = entry.getKey();
                if (!factory.isPropertySupported(name)) continue;
                factory.setProperty(name, entry.getValue());
            }
            if (this.output instanceof OutputStream) {
                if (this.outputEncoding != null) {
                    try {
                        this.writer = factory.createXMLStreamWriter((OutputStream)this.output, this.outputEncoding);
                    }
                    catch (XMLStreamException e) {
                        throw new StaxNavException(e);
                    }
                } else {
                    try {
                        this.writer = factory.createXMLStreamWriter((OutputStream)this.output);
                    }
                    catch (XMLStreamException e) {
                        throw new StaxNavException(e);
                    }
                }
            } else if (this.output instanceof Writer) {
                try {
                    this.writer = factory.createXMLStreamWriter((Writer)this.output);
                }
                catch (XMLStreamException e) {
                    throw new StaxNavException(e);
                }
            } else if (this.output instanceof Result) {
                try {
                    this.writer = factory.createXMLStreamWriter((Result)this.output);
                }
                catch (XMLStreamException e) {
                    throw new StaxNavException(e);
                }
            } else {
                throw new IllegalStateException("Unknown output: " + String.valueOf(this.output));
            }
        }
        return new StaxWriterImpl<N>(naming, this.writer, this.formatter, this.encoding, this.version);
    }
}

