/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization.metadata;

import java.util.ArrayList;
import org.exoplatform.commons.serialization.metadata.ArrayListTypeConverter;
import org.exoplatform.commons.serialization.metadata.ThreadTypeConverter;
import org.exoplatform.commons.serialization.model.ClassTypeModel;
import org.exoplatform.commons.serialization.model.ConvertedTypeModel;
import org.exoplatform.commons.serialization.model.SerializationMode;
import org.exoplatform.commons.serialization.model.TypeDomain;
import org.exoplatform.commons.serialization.model.metadata.DomainMetaData;
import org.exoplatform.component.test.AbstractGateInTest;

public class TestMetaData
extends AbstractGateInTest {
    public void testSerializedObjectClassType() throws Exception {
        DomainMetaData domainMD = new DomainMetaData();
        domainMD.addClassType(Object.class, true);
        TypeDomain typeDomain = new TypeDomain(domainMD);
        ClassTypeModel objectTM = (ClassTypeModel)typeDomain.addTypeModel(Object.class);
        TestMetaData.assertEquals((Object)SerializationMode.SERIALIZED, (Object)objectTM.getSerializationMode());
    }

    public void testObjectClassType() throws Exception {
        DomainMetaData domainMD = new DomainMetaData();
        domainMD.addClassType(Object.class, false);
        TypeDomain typeDomain = new TypeDomain(domainMD);
        ClassTypeModel objectTM = (ClassTypeModel)typeDomain.addTypeModel(Object.class);
        TestMetaData.assertEquals((Object)SerializationMode.NONE, (Object)objectTM.getSerializationMode());
    }

    public void testStringSerializedClassType() throws Exception {
        DomainMetaData domainMD = new DomainMetaData();
        domainMD.addClassType(String.class, true);
        TypeDomain typeDomain = new TypeDomain(domainMD);
        ClassTypeModel stringTM = (ClassTypeModel)typeDomain.addTypeModel(String.class);
        TestMetaData.assertEquals((Object)SerializationMode.SERIALIZED, (Object)stringTM.getSerializationMode());
    }

    public void testStringClassType() throws Exception {
        DomainMetaData domainMD = new DomainMetaData();
        domainMD.addClassType(String.class, false);
        TypeDomain typeDomain = new TypeDomain(domainMD);
        ClassTypeModel stringTM = (ClassTypeModel)typeDomain.addTypeModel(String.class);
        TestMetaData.assertEquals((Object)SerializationMode.SERIALIZABLE, (Object)stringTM.getSerializationMode());
    }

    public void testThreadConvertedType() throws Exception {
        DomainMetaData domainMD = new DomainMetaData();
        domainMD.addConvertedType(Thread.class, ThreadTypeConverter.class);
        TypeDomain typeDomain = new TypeDomain(domainMD);
        ConvertedTypeModel objectTM = (ConvertedTypeModel)typeDomain.addTypeModel(Thread.class);
        TestMetaData.assertEquals(ThreadTypeConverter.class, (Object)objectTM.getConverterJavaType());
    }

    public void testArrayListConvertedType() throws Exception {
        DomainMetaData domainMD = new DomainMetaData();
        domainMD.addConvertedType(ArrayList.class, ArrayListTypeConverter.class);
        TypeDomain typeDomain = new TypeDomain(domainMD);
        ConvertedTypeModel arrayListTM = (ConvertedTypeModel)typeDomain.addTypeModel(ArrayList.class);
        TestMetaData.assertEquals(ArrayListTypeConverter.class, (Object)arrayListTM.getConverterJavaType());
    }
}

