/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization.converter;

import java.io.InvalidObjectException;
import junit.framework.AssertionFailedError;
import org.exoplatform.commons.serialization.SerializationContext;
import org.exoplatform.commons.serialization.api.TypeConverter;
import org.exoplatform.commons.serialization.converter.A1;
import org.exoplatform.commons.serialization.converter.A2;
import org.exoplatform.commons.serialization.converter.A3;
import org.exoplatform.commons.serialization.converter.B1;
import org.exoplatform.commons.serialization.model.TypeDomain;
import org.exoplatform.component.test.AbstractGateInTest;

public class TestConverter
extends AbstractGateInTest {
    public void testConvertSerializedType() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(A1.class);
        A1 a = new A1("foo");
        A3.delegate = new TypeConverter<A1, A2>(this){

            public A2 write(A1 input) throws Exception {
                return new A2(input.state);
            }

            public A1 read(A2 output) throws Exception {
                return new A1(output.state);
            }
        };
        SerializationContext context = new SerializationContext(domain);
        a = (A1)context.clone((Object)a);
        TestConverter.assertEquals((String)"foo", (String)a.state);
    }

    public void testConvertSerializableType() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(B1.class);
        B1 b = new B1("foo");
        SerializationContext context = new SerializationContext(domain);
        b = (B1)context.clone((Object)b);
        TestConverter.assertEquals((String)"foo", (String)b.state);
    }

    public void testConverterWriteThrowsException() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(A1.class);
        A1 a = new A1("foo");
        final Exception e = new Exception();
        A3.delegate = new TypeConverter<A1, A2>(this){

            public A2 write(A1 input) throws Exception {
                throw e;
            }

            public A1 read(A2 output) throws Exception {
                throw new AssertionFailedError();
            }
        };
        SerializationContext context = new SerializationContext(domain);
        try {
            a = (A1)context.clone((Object)a);
            TestConverter.fail();
        }
        catch (InvalidObjectException ioe) {
            TestConverter.assertSame((Object)e, (Object)ioe.getCause());
        }
    }

    public void testConverterWriteReturnsNull() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(A1.class);
        A1 a = new A1("foo");
        A3.delegate = new TypeConverter<A1, A2>(this){

            public A2 write(A1 input) throws Exception {
                return null;
            }

            public A1 read(A2 output) throws Exception {
                throw new AssertionFailedError();
            }
        };
        SerializationContext context = new SerializationContext(domain);
        try {
            a = (A1)context.clone((Object)a);
            TestConverter.fail();
        }
        catch (InvalidObjectException invalidObjectException) {
            // empty catch block
        }
    }

    public void testConverterReadReturnsNull() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(A1.class);
        A1 a = new A1("foo");
        A3.delegate = new TypeConverter<A1, A2>(this){

            public A2 write(A1 input) throws Exception {
                return new A2(input.state);
            }

            public A1 read(A2 output) throws Exception {
                return null;
            }
        };
        SerializationContext context = new SerializationContext(domain);
        try {
            a = (A1)context.clone((Object)a);
            TestConverter.fail();
        }
        catch (InvalidObjectException invalidObjectException) {
            // empty catch block
        }
    }

    public void testConverterReadThrowsException() throws Exception {
        TypeDomain domain = new TypeDomain();
        domain.addTypeModel(A1.class);
        A1 a = new A1("foo");
        final Exception e = new Exception();
        A3.delegate = new TypeConverter<A1, A2>(this){

            public A2 write(A1 input) throws Exception {
                return new A2(input.state);
            }

            public A1 read(A2 output) throws Exception {
                throw e;
            }
        };
        SerializationContext context = new SerializationContext(domain);
        try {
            a = (A1)context.clone((Object)a);
            TestConverter.fail();
        }
        catch (InvalidObjectException ioe) {
            TestConverter.assertSame((Object)e, (Object)ioe.getCause());
        }
    }
}

