/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.integration.test;

import io.meeds.spring.module.service.TestCacheService;
import java.io.Serializable;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.jpa.CommonsDAOJPAImplTest;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(value={CommonsDAOJPAImplTest.class})
public class SpringCacheManagerTest
extends CommonsDAOJPAImplTest {
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private CacheService cacheService;
    @Autowired
    private TestCacheService testCacheService;

    @Test
    public void beansInjected() {
        SpringCacheManagerTest.assertNotNull((Object)PortalContainer.getInstance().getComponentInstanceOfType(CacheService.class));
        SpringCacheManagerTest.assertNotNull((Object)this.testCacheService);
        SpringCacheManagerTest.assertNotNull((Object)this.cacheService);
        SpringCacheManagerTest.assertNotNull((Object)this.cacheManager);
    }

    @Test
    public void cacheBehavior() {
        SpringCacheManagerTest.assertEquals((int)5, (int)this.testCacheService.get(5));
        SpringCacheManagerTest.assertEquals((int)14, (int)this.testCacheService.update(7));
        ExoCache cacheInstance = this.cacheService.getCacheInstance("cache-test");
        SpringCacheManagerTest.assertNotNull((Object)cacheInstance);
        SpringCacheManagerTest.assertEquals((Object)5, (Object)cacheInstance.get((Serializable)Integer.valueOf(5)));
        SpringCacheManagerTest.assertEquals((Object)14, (Object)cacheInstance.get((Serializable)Integer.valueOf(7)));
        this.testCacheService.remove(5);
        SpringCacheManagerTest.assertNull((Object)cacheInstance.get((Serializable)Integer.valueOf(5)));
        SpringCacheManagerTest.assertEquals((Object)14, (Object)cacheInstance.get((Serializable)Integer.valueOf(7)));
        this.testCacheService.remove(7);
        SpringCacheManagerTest.assertNull((Object)cacheInstance.get((Serializable)Integer.valueOf(5)));
        SpringCacheManagerTest.assertNull((Object)cacheInstance.get((Serializable)Integer.valueOf(7)));
    }
}

