/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.branding.BrandingService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MailUtilsTest {
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static ExoContainer container = (ExoContainer)Mockito.mock(ExoContainer.class);
    @Mock
    private BrandingService brandingService;
    @Mock
    private SettingService settingService;

    @BeforeClass
    public static void beforeRunBare() {
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getCurrentContainer()).thenReturn((Object)container);
    }

    @AfterClass
    public static void afterRunBare() {
        EXO_CONTAINER_CONTEXT.close();
    }

    @Before
    public void before() {
        Mockito.when((Object)((BrandingService)container.getComponentInstanceOfType(BrandingService.class))).thenReturn((Object)this.brandingService);
        Mockito.when((Object)((SettingService)container.getComponentInstanceOfType(SettingService.class))).thenReturn((Object)this.settingService);
    }

    @Test
    public void testGetSenderName() {
        String senderName = MailUtils.getSenderName();
        Assert.assertNull((Object)senderName);
        String companyName = "Company Name";
        Mockito.when((Object)this.brandingService.getCompanyName()).thenReturn((Object)companyName);
        senderName = MailUtils.getSenderName();
        Assert.assertEquals((Object)companyName, (Object)senderName);
        companyName = "Company Name From Settings";
        SettingValue settingValue = SettingValue.create((String)companyName);
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), "exo:notificationSenderName")).thenReturn((Object)settingValue);
        senderName = MailUtils.getSenderName();
        Assert.assertEquals((Object)companyName, (Object)senderName);
    }

    @Test
    public void testGetSenderEmail() {
        String senderEmail = MailUtils.getSenderEmail();
        Assert.assertEquals((Object)"noreply@meeds.io", (Object)senderEmail);
        String companyEmail = "email.property@test.com";
        System.setProperty("gatein.email.smtp.from", companyEmail);
        senderEmail = MailUtils.getSenderEmail();
        Assert.assertEquals((Object)companyEmail, (Object)senderEmail);
        companyEmail = "email.settings@test.com";
        SettingValue settingValue = SettingValue.create((String)companyEmail);
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), "exo:notificationSenderEmail")).thenReturn((Object)settingValue);
        senderEmail = MailUtils.getSenderEmail();
        Assert.assertEquals((Object)companyEmail, (Object)senderEmail);
    }
}

