/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.exoplatform.commons.utils.PropertyResolverReader;
import org.exoplatform.component.test.AbstractGateInTest;

public class TestPropertyResolverReader
extends AbstractGateInTest {
    public void testEmpty() throws Exception {
        this.testIncremental("", "");
        this.testSame("", "");
        this.testLarger("", "");
    }

    public void testChars() throws Exception {
        this.testIncremental("abc", "abc");
        this.testSame("abc", "abc");
        this.testLarger("abc", "abc");
    }

    public void testDollar1() throws Exception {
        this.testIncremental("$", "$");
        this.testSame("$", "$");
        this.testLarger("$", "$");
    }

    public void testDollar2() throws Exception {
        this.testIncremental("$a", "$a");
        this.testSame("$a", "$a");
        this.testLarger("$a", "$a");
    }

    public void testOpenProperty1() throws Exception {
        this.testIncremental("${", "${");
        this.testSame("${", "${");
        this.testLarger("${", "${");
    }

    public void testOpenProperty2() throws Exception {
        this.testIncremental("${a", "${a");
        this.testSame("${a", "${a");
        this.testLarger("${a", "${a");
    }

    public void testProperty1() throws Exception {
        this.testIncremental("a", "${a}");
        this.testSame("a", "${a}");
        this.testLarger("a", "${a}");
    }

    public void testProperty2() throws Exception {
        this.testIncremental("ab", "${a}b");
        this.testSame("ab", "${a}b");
        this.testLarger("ab", "${a}b");
    }

    public void testProperty3() throws Exception {
        this.testIncremental("6charsb", new PropertyResolverReader(this, new StringReader("${a}b")){

            protected String resolve(String name) {
                return "6chars";
            }
        });
        this.testSame("6charsb", new PropertyResolverReader(this, new StringReader("${a}b")){

            protected String resolve(String name) {
                return "6chars";
            }
        });
        this.testLarger("6charsb", new PropertyResolverReader(this, new StringReader("${a}b")){

            protected String resolve(String name) {
                return "6chars";
            }
        });
    }

    public void testProperty4() throws Exception {
        this.testIncremental("6charsb", new PropertyResolverReader(this, new StringReader("${a}b"), 5){

            protected String resolve(String name) {
                return "6chars";
            }
        });
        this.testSame("6charsb", new PropertyResolverReader(this, new StringReader("${a}b"), 5){

            protected String resolve(String name) {
                return "6chars";
            }
        });
        this.testLarger("6charsb", new PropertyResolverReader(this, new StringReader("${a}b"), 5){

            protected String resolve(String name) {
                return "6chars";
            }
        });
    }

    public void testNullProperty() throws Exception {
        this.testIncremental("${a}", new PropertyResolverReader(this, new StringReader("${a}")){

            protected String resolve(String name) {
                return null;
            }
        });
        this.testSame("${a}", new PropertyResolverReader(this, new StringReader("${a}")){

            protected String resolve(String name) {
                return null;
            }
        });
        this.testLarger("${a}", new PropertyResolverReader(this, new StringReader("${a}")){

            protected String resolve(String name) {
                return null;
            }
        });
    }

    public void testEmptyProperty() throws Exception {
        this.testIncremental("", new PropertyResolverReader(this, new StringReader("${a}")){

            protected String resolve(String name) {
                return "";
            }
        });
        this.testSame("", new PropertyResolverReader(this, new StringReader("${a}")){

            protected String resolve(String name) {
                return "";
            }
        });
        this.testLarger("", new PropertyResolverReader(this, new StringReader("${a}")){

            protected String resolve(String name) {
                return "";
            }
        });
    }

    private void testIncremental(String expected, String test) throws IOException {
        this.testIncremental(expected, new PropertyResolverReader((Reader)new StringReader(test)));
    }

    private void testIncremental(String expected, PropertyResolverReader r) throws IOException {
        char[] buffer = new char[expected.length()];
        for (int i = 0; i < expected.length(); ++i) {
            TestPropertyResolverReader.assertEquals((int)1, (int)r.read(buffer, i, 1));
        }
        TestPropertyResolverReader.assertEquals((int)-1, (int)r.read(new char[0], 0, 1));
        TestPropertyResolverReader.assertEquals((String)expected, (String)new String(buffer, 0, expected.length()));
    }

    private void testSame(String expected, String test) throws IOException {
        this.testSame(expected, new PropertyResolverReader((Reader)new StringReader(test)));
    }

    private void testSame(String expected, PropertyResolverReader r) throws IOException {
        char[] buffer = new char[expected.length()];
        int len = r.read(buffer, 0, expected.length());
        if (expected.length() == 0) {
            TestPropertyResolverReader.assertTrue((len == 0 || len == -1 ? 1 : 0) != 0);
        } else {
            TestPropertyResolverReader.assertEquals((int)expected.length(), (int)len);
        }
        TestPropertyResolverReader.assertEquals((int)-1, (int)r.read(new char[0], 0, 1));
        TestPropertyResolverReader.assertEquals((String)expected, (String)new String(buffer, 0, expected.length()));
    }

    private void testLarger(String expected, String test) throws IOException {
        this.testSame(expected, new PropertyResolverReader((Reader)new StringReader(test)));
    }

    private void testLarger(String expected, PropertyResolverReader r) throws IOException {
        char[] buffer = new char[expected.length() + 1];
        int len = r.read(buffer, 0, buffer.length);
        if (expected.length() == 0) {
            TestPropertyResolverReader.assertTrue((len == 0 || len == -1 ? 1 : 0) != 0);
        } else {
            TestPropertyResolverReader.assertEquals((int)expected.length(), (int)len);
        }
        TestPropertyResolverReader.assertEquals((int)-1, (int)r.read(new char[0], 0, 1));
        TestPropertyResolverReader.assertEquals((String)expected, (String)new String(buffer, 0, expected.length()));
    }
}

