/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import org.exoplatform.commons.utils.LazyList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;

public abstract class AbstractSerializablePageList<E>
extends PageList<E> {
    private static final Field pageSizeField;
    private LazyList<E> lazyList;

    protected AbstractSerializablePageList(int pageSize) {
        super(pageSize);
    }

    protected AbstractSerializablePageList() {
        super(10);
    }

    protected abstract ListAccess<E> connect() throws Exception;

    private void ensureCorrectState() {
        if (this.lazyList == null) {
            try {
                this.lazyList = new LazyList(this.connect(), super.getPageSize());
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
            int currentPage = this.currentPage_;
            super.setAvailablePage(this.lazyList.size());
            if (currentPage != -1) {
                this.currentPage_ = currentPage;
            }
        }
    }

    protected final void populateCurrentPage(int page) throws Exception {
        this.ensureCorrectState();
        int from = this.getFrom();
        int to = this.getTo();
        this.currentListPage_ = this.lazyList.subList(from, to);
    }

    public final List<E> getAll() {
        this.ensureCorrectState();
        return this.lazyList;
    }

    protected final void writeState(ObjectOutputStream out) throws IOException {
        int pageSize;
        try {
            pageSize = pageSizeField.getInt((Object)this);
        }
        catch (IllegalAccessException e) {
            InvalidObjectException ioe = new InvalidObjectException("Cannot set page size");
            ioe.initCause(e);
            throw ioe;
        }
        out.writeInt(pageSize);
        out.writeInt(this.currentPage_);
    }

    protected final void readState(ObjectInputStream in) throws IOException {
        try {
            pageSizeField.setInt((Object)this, in.readInt());
        }
        catch (IllegalAccessException e) {
            InvalidObjectException ioe = new InvalidObjectException("Cannot set page size");
            ioe.initCause(e);
            throw ioe;
        }
        this.currentPage_ = in.readInt();
    }

    public final int getAvailablePage() {
        this.ensureCorrectState();
        return super.getAvailablePage();
    }

    public final int getTo() {
        this.ensureCorrectState();
        return super.getTo();
    }

    public final int getFrom() {
        this.ensureCorrectState();
        return super.getFrom();
    }

    protected final void setAvailablePage(int available) {
        this.ensureCorrectState();
        super.setAvailablePage(available);
    }

    protected final void checkAndSetPage(int page) throws Exception {
        this.ensureCorrectState();
        super.checkAndSetPage(page);
    }

    public final List<E> getPage(int page) throws Exception {
        this.ensureCorrectState();
        return super.getPage(page);
    }

    public final List<E> currentPage() throws Exception {
        this.ensureCorrectState();
        return super.currentPage();
    }

    public final int getAvailable() {
        this.ensureCorrectState();
        return super.getAvailable();
    }

    public final int getCurrentPage() {
        this.ensureCorrectState();
        return super.getCurrentPage();
    }

    public final void setPageSize(int pageSize) {
        this.ensureCorrectState();
        super.setPageSize(pageSize);
    }

    public final int getPageSize() {
        this.ensureCorrectState();
        return super.getPageSize();
    }

    static {
        try {
            pageSizeField = PageList.class.getDeclaredField("pageSize_");
            pageSizeField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
    }
}

